<?php
$input=Factory::getInput();
$list_service_id=[];
if(array_key_exists('service_id',(array)$input->getData())) {
    $list_service_id=(array)$input->getData()['service_id'];
}
$list_category_id=[];
if(array_key_exists('category_id',(array)$input->getData())) {
    $list_category_id=(array)$input->getData()['category_id'];
}
?>
<div class="wrapper-filter">
    <div class="row">
        <div class="col-sm-12">
            <div class="input-filter">
                <div style="display: none" class="calendar"></div>
                <div class="time-range"></div>
                <div class="find_your_services">
                    <h4><?php esc_attr_e('Find Your services', 'wpbookingpro') ?></h4>
                    <div class="search">
                        <i class="icon-nb-search icon-keyword-search"></i>
                        <input type="text" value="<?php echo $this->keyword ?>" class="search form-control" name="keyword"
                               placeholder="<?php esc_attr_e('What are you looking for', 'wpbookingpro') ?>"/>
                    </div>
                    <div class="list-employee">
                        <select name="employee_id" class="list-employee">
                            <option value=""><?php esc_attr_e('Choose Your Expert', 'wpbookingpro') ?></option>
                            <?php foreach ($this->form->list_employee as $employee) { ?>
                                <option <?php echo ($this->employee_id == $employee->id) ? 'selected' : '' ?>
                                    value="<?php esc_html_e($employee->id); ?>"><?php esc_html_e($employee->full_name); ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="list-location">
                        <select name="location_id" class="list-location">
                            <option value=""><?php esc_attr_e('Select Address', 'wpbookingpro') ?></option>
                            <?php foreach ($this->form->list_location as $location) { ?>
                                <option <?php echo ($this->location_id == $location->id) ? 'selected' : '' ?>
                                    value="<?php esc_html_e($location->id); ?>"><?php esc_html_e($location->address); ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="list-category">
                    <h4><?php esc_attr_e('Filter By category', 'wpbookingpro') ?></h4>
                    <ul class="ul-list-category">
                        <?php foreach ($this->form->list_category as $category) { ?>
                            <li>
                                <div class="block-label">
                                    <label class="label-category">
                                        <?php if (count((array)$list_category_id)) {?>
                                            <input <?php echo (in_array($category->id,$list_category_id)?'checked':'')?> type="checkbox" class="check-box-category" name="category_id[]" value="<?php echo ($category->id);?>"/> <span><?php echo ($category->name);?></span>
                                        <?php } else {?>
                                            <input type="checkbox" class="check-box-category" name="category_id[]" value="<?php echo ($category->id);?>"/> <span><?php echo ($category->name);?></span>
                                        <?php }?>
                                        (<span><?php esc_html_e(count((array)$category->list_service)); ?></span>)
                                    </label>
                                    <i class="icon-nb-down-arrow"></i>
                                </div>
                                <ul class="ul-list-service">
                                    <?php foreach ($category->list_service as $service) {?>
                                        <?php if (count((array)$list_service_id)) {?>
                                            <li><label><input <?php echo (in_array($service->id,$list_service_id)?'checked':'')?> type="checkbox" name="service_id[]" value="<?php echo ($service->id);?>"/> <span><?php echo ($service->name);?></span></label></li>
                                        <?php } else {?>
                                            <li><label><input type="checkbox" name="service_id[]" value="<?php echo ($service->id);?>"/> <span><?php echo ($service->name);?></span></label></li>
                                        <?php }?>
                                    <?php }?>
                                </ul>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
                <button class="btn btn-primary button-filter" type="submit">Filter</button>
                <div class="block">
                    <?php $this->loadBlock("startservice") ?>
                </div>
            </div>
        </div>
    </div>
</div>
