<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_HtmlFrontend::_('jquery.icheck');
WpBookingPro_HtmlFrontend::_('jquery.confirm');

WpBookingPro_HtmlFrontend::_('jquery.ui_progress_bar');
$doc = Factory::getDocument();

$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_install_form.less');
$input = Factory::getInput();
$toolChecked = $input->get('tool', array(), 'array');
$step = $input->getInt('step', 0);
if ($step == 1) {
	array_unshift($toolChecked, "install_construct");
	array_unshift($toolChecked, "check_required");
	array_push($toolChecked, "finish_install");
}
$step++;
?>
    <div class="view-install-form">
        <div class="form-install" title="Form install">
            <h1><?php esc_attr_e('Welcome to woo booking','wpbookingpro')?></h1>
            <div class="tool-bar">
                <div class="row">
                    <div class="col-md-12">
                        <div class="pull-right">
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-main-tool">
                <form action="#" name="admin-form" method="post">
                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <h3 class="setup"><?php esc_attr_e('Setup','wpbookingpro')?></h3>
                        </div>
                    </div>
                    <div class="body">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="wrapper-tool">
                                    <ul class="list-tool">
                                        <li><label title=""><input type="checkbox" class="tool-item" checked disabled  /> <?php esc_attr_e('Check required','wpbookingpro')?> </label>
                                            <div class="description-content">
                                                <?php esc_attr_e('We need check list required before install this plugin:','wpbookingpro')?>
                                                <h3><?php esc_attr_e('List plugin required','wpbookingpro')?>:</h3>
                                                <ul>
                                                    <li><?php esc_attr_e('Woocommerce','wpbookingpro')?></li>
                                                    <li><?php esc_attr_e('Dokan','wpbookingpro')?></li>
                                                    <li><?php esc_attr_e('Woopanel','wpbookingpro')?></li>
                                                </ul>
                                            </div>
                                        </li>
                                        <li>
                                            <label title="Install construct database">
                                                <input type="checkbox" class="tool-item"  value="" checked disabled />
                                                <?php esc_attr_e('Install construct database','wpbookingpro')?>
                                            </label>
                                        </li>
                                        <li>
                                            <label title="Setup sample database">
                                                <input type="checkbox" class="tool-item"  name="tool[]" <?php echo in_array("setup_sample_database", $toolChecked) ? ' checked ' : '' ?> value="setup_sample_database" checked <?php echo wpbookingpro_render_content(($step == 2 ? " disabled " : "")) ?> />
                                                <?php esc_attr_e('Setup sample database','wpbookingpro')?>
                                                (<span class="recommend"><?php esc_attr_e('Recommend','wpbookingpro')?></span>)
                                            </label>
                                        </li>
                                        <li>
                                            <label title="Import media sample">
                                                <input type="checkbox" class="tool-item"  name="tool[]"  value="import_media_sample" <?php echo(($step == 2 ? " disabled " : "")) ?> <?php echo in_array("import_media_sample", $toolChecked) ? ' checked ' : '' ?> />
                                                <?php esc_attr_e('Import media sample','wpbookingpro')?>
                                            </label>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-9">
                                <div class="description">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="tool-bar pull-right">
                                <button class="btn btn-primary btn-next"
                                        type="button" <?php echo(($step == 2 ? " disabled " : "")) ?>>
                                    <?php esc_attr_e('Next','wpbookingpro')?>
                                </button>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="step" value="<?php wpbookingpro_render_content($step) ?>" />
                    <input type="hidden" name="task" value="install.next" />
                </form>
            </div>
        </div>
    </div>

<?php

$doc->addScriptApplySelector('.view-install-form','view_install_form',array(
    "step"=>  (int)$step,
    "tool_check"=> array_reverse($toolChecked),
    "all_tool_check"=> $toolChecked
),'nb_apps/nb_woobooking/assets/js/view_install_form.js');
