<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_CheckoutView")) {
    /**
     * Class WpBookingPro_CheckoutView
     */
    class WpBookingPro_CheckoutView extends WooBookingView
    {
        /**
         * @var
         */
        public $list;
        /**
         * @var
         */
        public $filterForm;
        /**
         * @var
         */
        public $cart;
        /**
         * @var void
         */
        public $user;

        /**
         * @param null $tpl
         * @return false|string
         * @throws Exception
         */
        public function display($tpl = null)
        {
            switch ($tpl) {
                case "config_list":
                    $modelBlock = WoobookingModel::getInstance('block');
                    $this->form = $modelBlock->getFormConfigBlock('service', $tpl);
                    break;
                case "form":
                    $id = $input->getInt('id', 0);
                    $this->item = $modelEvent->getItem($id);
                    $this->form = $modelEvent->getForm();
                    break;
                case "config_training":
                    break;
                case "list":
                default:
                    $this->user = Factory::getUser();
                    $appConfig = Factory::getAppConfig();
                    $login_before_checkout = $appConfig->get('login_before_checkout', 0);
                    /*if ($login_before_checkout == 1 && !$this->user->id) {
                        $this->redirect('wp-login.php?redirect_to=' . Factory::getRootUrl() . 'woobooking-checkout-list/');
                        return;
                    }*/
                    $input = Factory::getInput();
                    $modeCheckout = WoobookingModel::getInstance('checkout');
                    $this->form = $modeCheckout->getFormCheckout();
                    $modeCarts = WoobookingModel::getInstance('carts');
                    $this->cart = $modeCarts->getList();
                    break;
            }
            return parent::display($tpl);
        }
    }
}