<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_bookingView")) {
    /**
     * Class WpBookingPro_bookingView
     */
    class WpBookingPro_bookingView extends WooBookingView
    {
        /**
         * @var
         */
        public $list;
        /**
         * @var
         */
        public $filterForm;

        /**
         * @param null $tpl
         * @return false|string
         * @throws Exception
         */
        public function display($tpl = null)
        {
            $modelEvent = WoobookingModel::getInstance('event');
            $modelBooking = WoobookingModel::getInstance('booking');
            $input = Factory::getInput();
            switch ($tpl) {
                case "training":
                    $this->form = $modelBooking->getForm();
                    $this->item = $modelBooking->getItem();
                    $modeEvents = WoobookingModel::getInstance('events');
                    $this->form_booking = $modeEvents->getFormBooking();
                    break;
                case "thanks":
                    $order_id = $input->getInt('order_id', 0);
                    $orderModel = WoobookingModel::getInstance('order');
                    $this->form = $orderModel->getFormLayoutOrderDetail();
                    $this->item = $orderModel->getItem($order_id);
                    break;
                case "form":
                    $id = $input->getInt('id', 0);
                    $this->item = $modelEvent->getItem($id);
                    $this->form = $modelEvent->getForm();
                    break;
                case "config_training":
                    break;
                case "list":
                default:
                    $modelEvents = $this->getModel('events');
                    $this->filterForm = $modelEvents->getFilterForm();
                    $this->list = $modelEvents->getList();
                    break;
            }
            return parent::display($tpl);
        }
    }
}