<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Filesystem\File;
use Woobooking\CMS\Registry\Registry;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_EmployeeModel")) {
    /**
     * Class WpBookingPro_EmployeeModel
     */
    class WpBookingPro_EmployeeModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $table_name = "employee";
        /**
         * @var string
         */
        public $context = "employee";

        /**
         * @param array $data_post
         * @return array|bool|object
         * @throws Exception
         */
        public function save($data_post = array())
        {
            $input = Factory::getInput();
            $data_post = $input->getData()['data'];
            $params = $data_post['params'];
            $data_post['params'] = json_encode($params);
            $cover = $data_post['cover'];
            unset($data_post['cover']);
            $fullimage = $data_post['image'];
            unset($data_post['image']);
            $params = $data_post['params'];
            $employee = parent::save($data_post); // TODO: Change the autogenerated stub
            if ($cover) {
                if ($cover) {
                    $name = str_replace(' ', '_',Utility::random_string_by_time()) . $cover['name'];
                    $new_file_cover_path = WPBOOKINGPRO_PATH_ROOT . "/upload/employees/images/cover/$name";
                    $data_image = $cover['data'];
                    $data_image = base64_decode($data_image); // decode an image
                    if (!File::write($new_file_cover_path, $data_image)) {
                        throw new Exception("can not upload image cover");
                    }
                    $employee->cover = Utility::get_short_file_by_path($new_file_cover_path);
                }
                $employee = parent::save((array)$employee);
            }
            if ($fullimage) {
                if ($fullimage) {
                    $name = str_replace(' ', '_',Utility::random_string_by_time()) . $fullimage['name'];
                    $new_file_cover_path = WPBOOKINGPRO_PATH_ROOT . "/upload/employees/images/cover/$name";
                    $data_image = $fullimage['data'];
                    $data_image = base64_decode($data_image); // decode an image
                    if (!File::write($new_file_cover_path, $data_image)) {
                        throw new Exception("can not upload image cover");
                    }
                    $employee->image = Utility::get_short_file_by_path($new_file_cover_path);
                }
                $employee = parent::save((array)$employee);
            }
            $employee->full_name = "{$employee->first_name} {$employee->last_name}";
            $assignedservices = $data_post['assignedservices'];
            $assignedservices = base64_decode($assignedservices);
            $assignedservices = json_decode($assignedservices);
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->delete(WoobookingTable::getWBTable('service_employee'))
                ->where('employee_id=' . (int)$employee->id)
                ->where('enable_customize=1');
            $db->setQuery($query)->execute();
            foreach ($assignedservices as $employee_service) {
                if ($employee_service->enable_customize == 1) {
                    $query->clear()
                        ->insert(WoobookingTable::getWBTable('service_employee'))
                        ->set('employee_id=' . (int)$employee->id)
                        ->set('service_id=' . (int)$employee_service->service_id)
                        ->set('price=' . (int)$employee_service->price)
                        ->set('enable_customize=' . (int)$employee_service->enable_customize)
                        ->set('minimum_capacity=' . (int)$employee_service->minimum_capacity)
                        ->set('maximum_capacity=' . (int)$employee_service->maximum_capacity);
                    $db->setQuery($query)->execute();
                }
            }
            return $employee;
        }

        /**
         * @param int $id
         * @return mixed
         */
        public function getItem($id = 0)
        {
            $employee = parent::getItem($id); // TODO: Change the autogenerated stub
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->select("*")
                ->from(WoobookingTable::getWBTable('service_employee'))
                ->where('employee_id=' . (int)$employee->id);
            $employee->assignedservices = $db->setQuery($query)->loadObjectList('service_id');
            $register = new Registry();
            $register->loadString($employee->params);
            $employee->params = $register;
            return $employee;
        }
    }
}
