<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_CartsModel")) {
    /**
     * Class WpBookingPro_CartsModel
     */
    class WpBookingPro_CartsModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $context = "carts";
        /**
         * @var string
         */
        public $table_name = "cart";

        /**
         * @return array
         */
        public function getHeader()
        {
            return array();
        }

        /**
         * @return \WooBooking\CMS\Database\DatabaseQuery
         */
        public function getListQuery()
        {
            $session = Factory::getSession();
            $query = $this->db->getQuery(true);
            $query->select('cart.*')
                ->from($this->getTableName('cart') . ' as cart')
                ->leftJoin($this->getTableName('service') . ' AS service ON service.id=cart.service_id')
                ->select('service.name as service_name,service.price as service_price,service.image as service_image')
                ->leftJoin($this->getTableName('employee') . ' AS employee  ON employee.id=cart.employee_id')
                ->select('employee.first_name AS employee_first_name,employee.last_name AS employee_last_name,employee.cover AS employee_cover')
                ->leftJoin($this->getTableName('location') . ' AS location  ON location.id=cart.location_id')
                ->select('location.address AS location_address')
                ->where('cart.session_id=' . $query->quote($session->getId()));
            return $query;
        }
    }
}
