<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_CartModel")) {
    /**
     * Class WpBookingPro_CartModel
     */
    class WpBookingPro_CartModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $table_name = "cart";
        /**
         * @var string
         */
        public $context = "cart";

        /**
         * @param $data
         * @return array|bool|object
         * @throws Exception
         */
        public function add_to_cart($data)
        {
            $data['tax'] = isset($data['tax']) ? $data['tax'] : 0;
            $rate_id = $data['rate_id'];
            $session = Factory::getSession();
            $rateModel = WoobookingModel::getInstance('rate');
            $rate = $rateModel->getItem($rate_id);
            $eventModel = WoobookingModel::getInstance('event');
            $event = $eventModel->getItem($rate->object_id);
            $data_cart = [];
            $data_cart['first_name'] = $data['first_name'];
            $data_cart['last_name'] = $data['last_name'];
            $data_cart['session_id'] = $session->getId();
            $data_cart['rate_id'] = $rate_id;
            $data_cart['location_id'] = $event->location_id ? $event->location_id : $data['location_id'];
            $data_cart['service_id'] = $event->service_id ? $event->service_id : $data['service_id'];
            $data_cart['employee_id'] = $data['employee_id'];
            $data_cart['price'] = $event->price;
            $data_cart['tax'] = 0;
            $data_cart['subtotal'] = $event->price * $data['number_person'];
            $data_cart['total'] = $data_cart['subtotal'] + $data_cart['tax'] * $event->price;
            $data_cart['tax'] = $data['tax'] ? $data['tax'] : 0;
            $data_cart['start_date'] = $rate->from;
            $data_cart['end_date'] = $rate->to;
            $data_cart['type'] = "event";
            $data_cart['quantity'] = $data['number_person'];
            return $this->save($data_cart);
        }

        /**
         * @param $data
         * @return array|bool|object
         * @throws Exception
         */
        public function book_now($data)
        {
            $rate_id = $data['rate_id'];
            $rateModel = WoobookingModel::getInstance('rate');
            $rate = $rateModel->getItem($rate_id);
            $eventModel = WoobookingModel::getInstance('event');
            $event = $eventModel->getItem($rate->object_id);
            $data_cart = [];
            $data_cart['rate_id'] = $rate_id;
            $data_cart['location_id'] = $event->location_id;
            $data_cart['service_id'] = $event->service_id;
            $data_cart['employee_id'] = $data['employee_id'];
            $data_cart['price'] = $event->price;
            $data_cart['start_date'] = $rate->from;
            $data_cart['end_date'] = $rate->to;
            $data_cart['type'] = "event";
            return $this->save($data_cart);
        }

        /**
         * @return int
         */
        public function getTotal()
        {
            return 40;
        }
    }
}
