<?php

defined('_WPBOOKINGPRO_EXEC') or die;

use WooBooking\CMS\Utilities\Utility;

extract($displayData);


WpBookingPro_HtmlFrontend::_('jquery.framework');
WpBookingPro_HtmlFrontend::_('jquery.select_yes_no');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> field-yesno-<?php esc_html_e($name_format) ?> field-yesno">
        <div class="wrapper-yes-no">
            <div class="wrapper-left pull-left">
                <div class="wrapper-title-yes-no">
                    <span class="yesno-label"><?php esc_html_e($label) ?></span> <i
                            class="fas fa-question-circle"></i>
                </div>
            </div>
            <div class="wrapper-right pull-left">
                <input type="checkbox" class="form-check-input yes-no pull-right" <?php echo($value == 1 ? ' checked ' : '') ?> value="1" />
            </div>
        </div>
        <input type="hidden" name="<?php esc_html_e($name); ?>"  value="<?php esc_html_e($value) ?>" />
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-yesno','field_yesno',array(
    "field_name"=>  $name,
),
    'nb_apps/nb_woobooking/layouts/WooBooking/form/field/yesno.jquery.js');