<?php
use WooBooking\CMS\Utilities\Utility;defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$locationsModel = WoobookingModel::getInstance('locations');
$list_location = $locationsModel->getList();
$list_selected = is_array($value) ? $value : array();
?>
    <div class="<?php esc_html_e($class); ?> field-locations-<?php esc_html_e($name_format) ?> field-locations">
        <select name="<?php esc_html_e($name); ?>" <?php echo($multiple ? ' multiple ' : null); ?>
                class="form-control list-locations">
            <option value=""><?php esc_attr_e('Select location','wpbookingpro')?></option>
			<?php foreach ($list_location as $location) { ?>
                <option <?php echo(in_array($location->id, $list_selected) ? " selected " : "") ?> value="<?php esc_html_e($location->id); ?>"><?php esc_html_e($location->address); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingPro_HtmlFrontend::_('jquery.select2');
$doc->addLessStylesheet('nb_apps/nb_woobooking/layouts/WooBooking/form/field/locations.less');
$doc->addScriptApplySelector('.field-locations','field_locations',array(
    "field_name"=>  $name,
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/locations.jquery.js');