<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Utilities\Utility as UtilityAlias;
if(!class_exists("WpBookingPro_CountryController")) {
    /**
     * Class WpBookingPro_CountryController
     */
    class WpBookingPro_BlockController extends woobooking_controller_frontend
    {
        /**
         * @return mixed
         * @throws Exception
         */
        public function preview()
        {

            $input = Factory::getInput();
            $modelBlock = WoobookingModel::getInstance('block');
            $open_source_client_id = $input->getString('open_source_client_id', '');
            $type = $input->get('type', '');
            if ($open_source_client_id != "") {
                $block = $modelBlock->getBlockByOpenSourceId($open_source_client_id);
            } else {
                throw new Exception("can not found open_source_client_id");
            }
            if (!$block->id) {
                $array_block = array(
                    'type' => $type,
                    'open_source_client_id' => $open_source_client_id,
                );
                $block = $modelBlock->save($array_block);
            }
            $input->set('id', $block->id);
            return $this->view("block.preview");
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function config()
        {
            $input = Factory::getInput();
            $open_source_client_id = $input->getString('open_source_client_id', '');
            $modelBlock = WoobookingModel::getInstance('block');
            if ($open_source_client_id != "") {
                $block = $modelBlock->getBlockByOpenSourceId($open_source_client_id);
            }
            if (!$block->id) {
                throw new Exception("can not found block item");
            }
            $input->set('id', $block->id);
            return $this->view("block.config");
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function save_config()
        {
            $input = Factory::getInput();
            $data = $input->getData();

            $blockModel = WoobookingModel::getInstance('block');

            $open_source_client_id = $input->getString('open_source_client_id', '');
            if ($open_source_client_id != "") {
                $block = $blockModel->getBlockByOpenSourceId($open_source_client_id);
            }
            $data['id'] = $block->id;
            $data['params'] = json_encode($data['params']);
            $block = $blockModel->save($data);
            $input->set('id', $block->id);
            return $this->view("block.preview");

        }

        /**
         * @return false|mixed|string
         * @throws Exception
         */
        public function ajax_get_config_blog()
        {

            $input = Factory::getInput();
            $modelBlock = WoobookingModel::getInstance('block');
            $id = $input->getInt('id', 0);
            $type = $input->get('type', '');
            if (!$id) {
                $block = $modelBlock->createNewBlock($type);
                $input->set('block_id', $block->id);
            }

            if (strpos($type, '-block-') !== false) {

                list($package, $block, $block_name) = explode("-", $type);
                return $this->config_block($block_name);
            } else {

                list($package, $view, $layout) = explode("-", $type);
                return $this->view_config_block_app("$view.config_$layout");
            }
        }

        /**
         * @param $layout
         * @return mixed
         * @throws Exception
         */
        public static function view_config_block_app($layout)
        {
            list($view, $tpl) = explode(".", $layout);
            $view_path = WPBOOKINGPRO_PATH_COMPONENT . "/views/$view/view.html.php";
            if (file_exists($view_path)) {
                require_once $view_path;
                $UFCiew = ucfirst($view);
                $view_name = "{$UFCiew}View";
                $view_class = new $view_name();
                $view_class->view = $view;
                return $view_class->view_config_block_app($tpl);
            } else {
                throw new Exception("Error: view <b>$view_path</b> not exists please create it");
            }
        }

        /**
         * @param $block_name
         * @param null $config_layout
         * @return false|string
         * @throws Exception
         */
        public static function config_block($block_name, $config_layout = null)
        {
            $block_view_path = WPBOOKINGPRO_PATH_COMPONENT_FRONT_END . "/views/block/view.html.php";
            if (file_exists($block_view_path)) {
                require_once $block_view_path;
                $view_class = new WpBookingPro_BlockView();
                $view_class->view = "block";
                return $view_class->display_config_block($block_name);
            } else {
                throw new Exception("Error: view <b>$block_view_path</b> not exists please create it");
            }
        }

        /**
         * @param $block_id
         * @param $layout
         * @return false|string
         * @throws Exception
         */
        public static function display_block($block_id, $layout)
        {
            $blockModel = WoobookingModel::getInstance('block');
            $block = $blockModel->getItem($block_id);
            $block_view_path = WPBOOKINGPRO_PATH_COMPONENT_FRONT_END . "/views/block/view.html.php";
            if (file_exists($block_view_path)) {
                require_once $block_view_path;
                $view_class = new WpBookingPro_BlockView();
                $view_class->view = "block";
                return $view_class->display_block($block_name);
            } else {
                throw new Exception("Error: view <b>$block_view_path</b> not exists please create it");
            }
            list($view, $tpl) = explode(".", $layout);
            $view_path = WPBOOKINGPRO_PATH_COMPONENT . "/views/$view/view.html.php";
            if (file_exists($view_path)) {
                require_once $view_path;
                $UFCiew = ucfirst($view);
                $view_name = "{$UFCiew}View";
                $view_class = new $view_name();
                $view_class->view = $view;
                return $view_class->display_block($block, $tpl);
            } else {
                throw new Exception("Error: view <b>$view_path</b> not exists please create it");
            }
        }
    }
}