<?php
use WooBooking\CMS\Utilities\Utility;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.select2');
WpBookingPro_Html::_('script', 'system/html5fallback.js', array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));

$list = '';

if ($options)
{
	$list = 'list="' . $id . '_datalist"';
}

$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;

$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$doc=Factory::getDocument();


$db=Factory::getDBO();
$query=$db->getQuery(true);
$query->select('*')
    ->from(WoobookingTable::getWBTable('location'))
;
$list=$db->setQuery($query)->loadObjectList();


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
<div id="<?php wpbookingpro_render_content($id_by_name) ?>" class="field-custom-address">
    <div class="row">
        <div class="col-md-3"><label><?php echo WoobookingText::_('SELECT_ADDRESS') ?></label></div>
        <div class="col-md-9">
            <select name="<?php wpbookingpro_render_content($name); ?>" class="list-address">
                <option value=""><?php echo  WoobookingText::_('CUSTOM_ADDRESS') ?></option>
                <?php foreach ($list as $item){ ?>
                    <option <?php wpbookingpro_render_content($value==$item->id?' selected ':'') ?> value="<?php wpbookingpro_render_content($item->id);?>"><?php wpbookingpro_render_content($item->address);?></option>
                <?php } ?>
            </select>
        </div>
    </div>
    <div class="wrapper-custom-address" style="<?php echo  $value!==""?' display: none ':'' ?> ">
        <div class="row">
            <div class="col-md-12">
                <input type="text" name="<?php echo  $name_custom_address ?>" placeholder="<?php echo  WoobookingText::_('CUSTOM_ADDRESS') ?>" class="form-control custom-address" />
            </div>
        </div>
    </div>
</div>

<?php
$doc->addScriptApplySelector('.field-custom-address','field_CustomAddress',array(
),'layouts/WooBooking/form/field/jquery.CustomAddress.js');
