<?php
$item = $this->item;
$open_source=Factory::getOpenSource();
$product=$open_source->getEcommerce()->get_product($item->open_source_link_id);
?>
<div class="wrapper-service-item btn-edit-service" data-category_id="<?php esc_html_e($item->category_id) ?>"
     data-id="<?php esc_html_e($item->id) ?>">
    <input type="checkbox" class="delete-service" name="list_delete_service_id[]" value="<?php esc_html_e($item->id) ?>" />
    <div class="wrapper-service-content">
        <div class="row">
            <div class="col-md-3">
                <div class="service-item-content ">
                    <i class="icon-menu far flaticon-menu-2 pull-left"></i>
                    <span class="name pull-left"><?php esc_html_e($item->name) ?></span>
                    <span class="link-product">
						<?php if ($item->open_source_link_id && $product) { ?>
                            <a target="_blank"
                               href="<?php esc_html_e(get_permalink($item->open_source_link_id))  ?>"><?php esc_html_e($product->get_name()); ?></a>
						<?php } else { ?>
							<?php esc_attr_e('No link open source item','wpbookingpro') ?>
						<?php } ?>
                    </span>
                </div>
            </div>
            <div class="col-md-3">
                <img class="service-image" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?><?php esc_html_e($item->image) ?>" alt="service-image" />
            </div>
            <div class="col-md-3"><?php esc_attr_e('Duration','wpbookingpro') ?>:<span
                        class="duration"><?php esc_html_e(WpBookingPro_Helper::format_hour($item->duration)) ?></span></div>
            <div class="col-md-3"><?php esc_attr_e('Price','wpbookingpro') ?>:<span
                        class="price"><?php esc_html_e(WpBookingPro_Helper::format_currency($item->price)) ?></span></div>
        </div>
    </div>
</div>
