<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_Html::_('jquery.icheck');
WpBookingPro_Html::_('jquery.confirm');

WpBookingPro_Html::_('jquery.loading_js');
WpBookingPro_Html::_('jquery.ui_progress_bar');
WpBookingPro_Html::_('jquery.waitingfor');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_config_install.less');

$input = Factory::getInput();
$toolChecked = $input->get('tool', array(), 'array');
$step = $input->getInt('step', 0);
if ($step == 1) {
    array_unshift($toolChecked, "install_construct");
    array_unshift($toolChecked, "check_required");
    array_push($toolChecked, "finish_install");
}
$step++;
$list_lang_install=array(
       "install_construct"=>esc_html__('Install construct','wpbookingpro'),
       "check_required"=>esc_html__('Check required','wpbookingpro'),
       "setup_sample_database"=>esc_html__('Setup sample database','wpbookingpro'),
       "import_media_sample"=>esc_html__('Import media sample','wpbookingpro'),
       "finish_install"=>esc_html__('Finish install','wpbookingpro'),
);
?>
    <div class="view-config-install">
        <div class="row">
            <div class="col-md-3"></div>
            <div class="col-md-6">
                <div class="form-install" title="Form install">
                    <div class="tool-bar">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="pull-right">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wrapper-main-tool">
                        <h3><?php esc_attr_e('Welcome to WPbooking pro','wpbookingpro')?></h3>
                        <form action="<?php esc_html_e(Factory::getRootUrl())  ?>wp-admin/admin.php?page=wb_config&layout=install" name="admin-form" method="post">
                            <h4 class="setup"><?php echo esc_attr_e('Setup', 'wpbookingpro')?></h4>
                            <div class="wrapper-tool">
                                <ul class="list-tool">
                                    <li>
                                        <label title="<?php esc_attr_e('Check required','wpbookingpro')?>">
                                            <input class="tool-item" checked disabled type="checkbox" /> <?php esc_attr_e('Check required','wpbookingpro')?>
                                        </label>
                                        <div class="description-content">
                                        </div>
                                    </li>
                                    <li>
                                        <label title="<?php esc_attr_e('Install construct database','wpbookingpro')?>">
                                            <input class="tool-item" checked disabled type="checkbox" />
                                            <?php esc_attr_e('Install construct database','wpbookingpro')?>
                                        </label>
                                    </li>
                                    <li>
                                        <label title="<?php esc_attr_e('Setup sample database','wpbookingpro')?>">
                                            <input type="checkbox" class="tool-item" checked <?php esc_html_e(($step == 2 ? " disabled " : "")) ?>name="tool[]" <?php echo in_array("setup_sample_database", $toolChecked) ? ' checked ' : '' ?> value="setup_sample_database"  />
                                            <?php esc_attr_e('Setup sample database','wpbookingpro')?>(<span class="recommend"><?php esc_attr_e('recommend','wpbookingpro')?></span>)
                                        </label>
                                    </li>
                                    <li>
                                        <label title="<?php echo esc_attr_e('Import media sample','wpbookingpro')?>">
                                            <input type="checkbox" class="tool-item" name="tool[]" <?php esc_html_e(($step == 2 ? " disabled " : "")) ?> <?php echo in_array("import_media_sample", $toolChecked) ? ' checked ' : '' ?> value="import_media_sample"  />
                                            <?php esc_attr_e('Import media sample','wpbookingpro')?>(<span class="recommend"><?php esc_attr_e('take 3 minutes, optional','wpbookingpro')?></span>)
                                        </label>
                                    </li>
                                </ul>
                                <div class="tool-bar">
                                    <button class="btn btn-primary btn-next"
                                            type="button" <?php echo esc_attr_e(($step == 2 ? " disabled " : ""),'wpbookingpro') ?>>
                                        <?php esc_attr_e('Next','wpbookingpro') ?>
                                    </button>
                                </div>
                            </div>
                            <input type="hidden" name="step" value="<?php esc_html_e($step) ?>" />
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php



$doc->addScriptApplySelector('.view-config-install','view_config_install',array(
    "step"=>  (int)$step,
    "tool_check"=>  array_reverse($toolChecked),
    "list_lang_install"=>$list_lang_install
),'admin/nb_apps/nb_woobooking/assets/js/view_config_install.js');

