<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_EventsModel")) {
    /**
     * Class WpBookingPro_EventsModel
     */
    class WpBookingPro_EventsModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $context = "events";
        /**
         * @var string
         */
        public $table_name = "event";

        /**
         * @return mixed
         */
        public function getList()
        {
            $db = Factory::getDBO();
            $query = $this->getListQuery();
            $list = $db->setQuery($query)->loadObjectList();
            foreach ($list as &$item) {
                $query = $this->db->getQuery(true);
                $query->clear()
                    ->select('rate.*')
                    ->from($this->getTableName('rate') . ' AS rate')
                    ->where('rate.object_id=' . (int)$item->id);
                $list_rate = $this->db->setQuery($query)->loadObjectList();
                $item->list_rate = $list_rate;
                $sum = 0;
                $total_person = 0;
                foreach ($list_rate as $rate) {
                    $query->clear()
                        ->select("COUNT(wb_order.id) AS total_order")
                        ->from($query->quoteName($this->getTableName('order')) . ' AS wb_order')
                        ->leftJoin($this->getTableName('order_detail') . ' AS order_detail ON order_detail.order_id=wb_order.id')
                        ->select('order_detail.*')
                        ->leftJoin($this->getTableName('order_detail_rate') . ' AS order_detail_rate ON order_detail_rate.order_detail_id=order_detail.id')
                        ->select('SUM(order_detail_rate.quantity) AS total_person')
                        ->where('order_detail_rate.rate_id=' . (int)$rate->id)
                        ->where('wb_order.order_status_id=5');
                    $order_detail_object = $this->db->setQuery($query)->loadObject();
                    $sum += $order_detail_object->total_order;
                    $total_person += $order_detail_object->total_person;
                    $rate->total_order_per_rate = $order_detail_object->total_order;
                    $rate->total_person_per_rate = $order_detail_object->total_person;
                }
                $item->total_order = $sum;
                $item->total_person = $total_person;
            }
            return $list;
        }

        /**
         * @return array
         */
        public function getHeader()
        {
            return array();
        }
    }
}