<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_CustomersModel")) {
    /**
     * Class WpBookingPro_CustomersModel
     * @author cuongnd cuongnd@gmail.com
     * @license http://www.fsdf.com
     */
    class WpBookingPro_CustomersModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $table_name = "customer";
        /**
         * @var string
         */
        public $context = "customers";

        /**
         * @return mixed
         */
        public function getList()
        {
            $list = parent::getList(); // TODO: Change the autogenerated stub
            foreach ($list as $item) {
                $item->full_name = "{$item->first_name} {$item->last_name}";
            }
            return $list;
        }

        /**
         * @return mixed
         */
        public function get_list_customer_in_year()
        {
            $now = Factory::getDate();
            $now1 = $now->modify('-12 month');
            $query = $this->_db->getQuery(true);
            $query->select('customer1.*')
                ->select('MONTH(customer1.created_date) AS month')
                ->from($this->getTableName('customer') . ' AS customer1')
                ->where('customer1.created_date>=' . $query->quote($now1->toSql()));
            $list = $this->_db->setQuery($query)->loadObjectList();
            foreach ($list as $item) {
                $item->full_name = "{$item->first_name} {$item->last_name}";
            }
            return $list;
        }
    }
}