<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Form\Form;
use Woobooking\CMS\Registry\Registry;
if(!class_exists("WpBookingPro_ConfigModel")) {
    /**
     * Class WpBookingPro_ConfigModel
     */
    class WpBookingPro_ConfigModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $context = "config";
        /**
         * @var string
         */
        public $table_name = "config";
        /**
         * @var array
         */
        public static $list_menu_by_xml = array();

        /**
         * @param array $data
         * @return array|bool|object|void
         * @throws Exception
         */
        public function save($data = array())
        {
            $table = $this->getTable('config');
            $table->load(1);
            $param = $data['params'];
            $param = json_encode($param);
            $table->params = $param;
            $table->store();
        }

        /**
         * @param int $id
         * @return mixed
         */
        public function getItem($id = 0)
        {
            $item = parent::getItem(1); // TODO: Change the autogenerated stub
            $param = $item->params;
            $reg = new Registry();
            $reg->loadString($param);
            $item->params = $reg;
            return $item;
        }

        /**
         * @return array|mixed
         */
        public function get_list_view_publish()
        {
            $db = Factory::getDBO();
            $query_check_table = $db->getQuery(true);
            $query_check_table->setQuery("SHOW TABLES LIKE '" . $this->getTableName('view') . "'");
            $tables = $db->setQuery($query_check_table)->loadColumn();
            if (count($tables)) {
                $query = $db->getQuery(true);
                $query->select('view.name')
                    ->from($this->getTableName('view') . ' AS view')
                    ->where('view.published=1');
                $listview = $db->setQuery($query)->loadColumn();
            } else {
                $listview = self::get_list_view_xml();
            }
            return $listview;
        }

        /**
         * @return array
         */
        public static function get_list_view_xml()
        {
            if (empty(self::$list_menu_by_xml)) {
                $file_xml_path_app = WPBOOKINGPRO_PATH_ADMIN_COMPONENT1 . "/views.xml";
                $xml = simplexml_load_file($file_xml_path_app);
                $list_menu_by_xml = [];
                foreach ($xml->view as $view) {
                    $is_system = (string)$view->attributes()['is_system'];
                    if ($is_system == 1) {
                        $list_menu_by_xml[] = (object)[
                            'id' => (string)$view->attributes()['id'],
                            'menu_slug' => (string)$view->attributes()['menu_slug'],
                            'label' => (string)$view->attributes()['label'],
                            'page_title' => (string)$view->attributes()['page_title'],
                            'capability' => (string)$view->attributes()['capability'],
                            'icon' => (string)$view->attributes()['icon'],
                            'is_system' => (string)$view->attributes()['is_system'],
                        ];
                    }
                }
                self::$list_menu_by_xml = $list_menu_by_xml;
            }
            return self::$list_menu_by_xml;
        }

        /**
         * @return bool|Form
         */
        public function getFormCreateView()
        {
            Form::addFieldPath(WPBOOKINGPRO_PATH_ROOT . '/lib/Form/Field');
            Form::addFieldPath(WPBOOKINGPRO_PATH_ROOT . '/lib/WooBooking/form/fields');
            Form::addFormPath(WPBOOKINGPRO_PATH_COMPONENT . '/models/forms');
            try {
                $data = [
                    "views" => $this->get_list_view_publish()
                ];
                $form = Form::getInstance("create_view");
                $form->bind($data);
            } catch (\Exception $e) {
                wpbookingpro_render_content($e->getMessage());
                die;
                $this->setError($e->getMessage());
                return false;
            }
            return $form;
        }
    }
}