<?php


use Woobooking\CMS\Registry\Registry;

defined('_WPBOOKINGPRO_EXEC') or die;
$data = $displayData;

$data['options'] = !empty($data['options']) ? $data['options'] : array();
if (is_array($data['options'])) {
	$data['options'] = new Registry($data['options']);
}

$filterButton = $data['options']->get('filterButton', true);
$searchButton = $data['options']->get('searchButton', true);
$filters = $data['view']->filterForm->getGroup('filter');
?>
<?php if (!empty($filters['filter_search'])) : ?>
	<?php if ($searchButton) : ?>
        <label for="filter_search" class="element-invisible">
			<?php if (isset($filters['filter_search']->label)) : ?>
				<?php esc_html_e(WoobookingText::_($filters['filter_search']->label)); ?>
			<?php else : ?>
				<?php esc_html_e(WoobookingText::_('JSEARCH_FILTER')); ?>
			<?php endif; ?>
        </label>
        <div class="btn-wrapper input-append">
			<?php $filters['filter_search']->input; ?>
			<?php if ($filters['filter_search']->description) : ?>
			<?php endif; ?>
            <button type="submit" class="btn hasTooltip btn-primary"
                    title="<?php esc_html_e(WpBookingPro_Html::_('tooltipText', 'JSEARCH_FILTER_SUBMIT')); ?>"
                    aria-label="<?php esc_html_e(WoobookingText::_('JSEARCH_FILTER_SUBMIT')); ?>">
                <span class="flaticon-close" aria-hidden="true"></span>
            </button>
        </div>
		<?php if ($filterButton) : ?>
            <div class="btn-wrapper hidden-phone">
                <button type="button" class="btn hasTooltip js-stools-btn-filter btn-primary"
                        title="<?php esc_html_e(WpBookingPro_Html::_('tooltipText', 'JSEARCH_TOOLS_DESC')); ?>">
					<?php esc_attr_e('Jsearch tools','wpbookingpro'); ?> <span class="caret"></span>
                </button>
            </div>
		<?php endif; ?>
        <div class="btn-wrapper">
            <button type="button" class="btn hasTooltip js-stools-btn-clear btn-danger"
                    title="<?php esc_html_e(WpBookingPro_Html::_('tooltipText', 'JSEARCH_FILTER_CLEAR')); ?>">
				<?php esc_attr_e('Jsearch filter clear','wpbookingpro'); ?>
            </button>
        </div>
	<?php endif; ?>
<?php endif;
