<?php
use WooBooking\CMS\Utilities\ArrayHelper;
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.auto_numeric');
WpBookingPro_Html::_('jquery.base64');
WpBookingPro_Html::_('jquery.select2');
WpBookingPro_Html::_('jquery.icheck');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
WpBookingPro_Html::_('jquery.increment');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$modelServices = WoobookingModel::getInstance('services');
$list_service = $modelServices->getList();
$list_service = ArrayHelper::pivot($list_service, 'id');
$modelLocations = WoobookingModel::getInstance('locations');
$list_location = $modelLocations->getList();
$list_location = ArrayHelper::pivot($list_location, 'id');
$list_service_selected_by_employee = $value;
$days = [
	'Monday',
	'Tuesday',
	'Wednesday',
	'Thursday',
	'Friday',
	'Saturday',
	'Sunday'
];
$list_time = [];
for ($i = 0; $i < 24; $i++) {
	if ($i < 10) {
		$prefix_value = "0$i";
	} else {
		$prefix_value = $i;
	}
	$item = new stdClass();
	$item->value = $i;
	$item->text = $prefix_value . ':00';
	$list_time[] = $item;
	$item = new stdClass();
	$item->value = $i + 0.5;
	$item->text = $prefix_value . ":30";
	$list_time[] = $item;
}
$render_body_template = function ($list_time, $list_service, $list_location) {
	ob_start();
	?>
    <div class="body-content">
        <div class="row">
            <div class="col-md-12">
                <div class="controllers-top">
                    <div class="pull-left">
                        <label><input type="radio" checked name="time_type" value="work_hours" /> <?php esc_attr_e_('Work Hours','wpbookingpro') ?></label>
                        <label><input type="radio" name="time_type" value="breaks" /> <?php esc_attr_e_('Breaks','wpbookingpro') ?></label>
                    </div>
                </div>
            </div>
        </div>
        <div class="row-work-hours">
            <div class="row ">
                <div class="col-md-3">
                    <br/>
                    <select class="list-time-start">
                        <option value=""><?php esc_attr_e('Select time','wpbookingpro') ?></option>
						<?php foreach ($list_time as $time) { ?>
                            <option value="<?php echo esc_html_e($time->value) ?>"><?php esc_html_e($time->text); ?></option>
						<?php } ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <br/>
                    <select class="list-time-end">
                        <option value=""><?php esc_attr_e('Select time','wpbookingpro') ?></option>
						<?php foreach ($list_time as $time) { ?>
                            <option value="<?php esc_html_e($time->value) ?>"><?php esc_html_e($time->text); ?></option>
						<?php } ?>
                    </select>
                </div>
                <div class="col-md-3">
                    Services
                    <select class="list-service" multiple>
                        <option value=""><?php esc_attr_e('Select service','wpbookingpro') ?></option>
						<?php foreach ($list_service as $service) { ?>
                            <option value="<?php esc_html_e($service->id) ?>"><?php esc_html_e($service->name); ?></option>
						<?php } ?>
                    </select>
                </div>
                <div class="col-md-3">
                    Location
                    <select class="list-location">
                        <option value=""><?php esc_attr_e('Select_location','wpbookingpro') ?></option>
						<?php foreach ($list_location as $location) { ?>
                            <option value="<?php esc_html_e($location->id) ?>"><?php esc_html_e($location->address); ?></option>
						<?php } ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="row-breaks">
            <div class="row">
                <div class="col-md-12">
                    <p><?php esc_attr_e_('Work Hours','wpbookingpro') ?></p>
                    <div>
                        <input type="text" />
                        <input type="text" />
                    </div>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="row">
            <div class="col-md-12">
                <div class="pull-left controllers">
                    <button type="button" class="btn btn-primary btn-sm btn-cancel-range-time"><i
                                class="far fa-window-close"></i> <?php esc_attr_e_('Cancel','wpbookingpro') ?>
                    </button>
                    <button type="button" class="btn btn-primary btn-sm btn-save-range-time"><i class="fas fa-save"></i>
                        <?php esc_attr_e_('Save','wpbookingpro') ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
	<?php
	return ob_get_clean();
};
?>
<?php
$render_footer = function () {
	ob_start();
	?>
    <div class="row">
        <div class="col-md-3"><span class="time"></span></div>
        <div class="col-md-6"><span class="list-service"></span></div>
        <div class="col-md-3">
            <div class="pull-right group-footer">
                <span class="location"></span>
                <i class="far fa-edit edit-range-time"></i>
                <i class="fas fa-minus-square"></i>
            </div>
        </div>
    </div>
	<?php
	$content = ob_get_clean();
	return $content;
}
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-workhours">
        <div class="wrapper-workhours">
			<?php foreach ($days as $day) { ?>
                <div class="wrapper-workhours-item">
                    <div class="header">
                        <div class="row">
                            <div class="col-md-6"><span class="day"><?php esc_attr_e($day) ?></span></div>
                            <div class="col-md-6">
                                <div class="pull-right">
                                    <span class="apply-to-all"><?php esc_attr_e_('Apply to All Days','wpbookingpro') ?></span>
                                    <i class="fas fa-plus-circle add-range-time"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="body">
                    </div>
                    <div class="footer">
                    </div>
                </div>
			<?php } ?>
        </div>
        <input type="hidden" name="<?php esc_html_e($name); ?>" />
    </div>
<?php
$list_employee_service = $value;
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/workhours.less');
$doc->addScriptApplySelector('.field-workhours','field_workhours',array(
    "input_name"=>  $name,
    "template_body_of_day"=>  render_body_template($list_time, $list_service, $list_location),
    "template_footer_of_day"=>  render_footer(),
    "list_service"=>  $list_service,
    "list_location"=>  $list_location,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/workhours.jquery.js');