<?php

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
?>
<input type="text" id="<?php
esc_html_e($id); ?>" name="<?php
esc_html_e($name); ?>"  <?php
esc_html_e($dirname); ?> value="<?php
esc_html_e(htmlspecialchars($value, ENT_COMPAT, 'UTF-8')); ?>" <?php echo(implode(' ',
	$attributes)); ?> />
<?php if ($options) : ?>
    <datalist id="<?php esc_html_e($id); ?>_datalist">
		<?php foreach ($options as $option) : ?>
			<?php if (!$option->value) : ?>
				<?php continue; ?>
			<?php endif; ?>
            <option value="<?php esc_html_e($option->value); ?>"><?php esc_html_e($option->text); ?></option>
		<?php endforeach; ?>
    </datalist>
<?php endif; ?>
