<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-selectfolderpath">
        <div class="wrapper-field-selectfolderpath">
            <div class="tree-folder">
            </div>
            <button type="button" class="btn btn-primary select-folder-path"><i class="far fa-folder"></i>
                <?php esc_attr_e_('Select Path','wpbookingpro') ?>
            </button>
            <br/>
            <br/>
            <input type="text" class="folder-path form-control" name="<?php esc_html_e($name); ?>" value="<?php esc_html_e($value) ?>" />
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-selectfolderpath','field_selectfolderpath',array(
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/selectfolderpath.jquery.js');