(function ($) {
    $.field_selectday = function (element, options) {
        var defaults = {
            input_name: "",
            value:[]
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('input.day-of-week').iCheck({
                checkboxClass: 'icheckbox_minimal',
                radioClass: 'iradio_minimal',
                increaseArea: '20%'
            });
            let value=plugin.settings.value;
            let list_working_day=Array.isArray(value)?value:[];
            $(`input[name="${plugin.settings.input_name}"]`).val(JSON.stringify(value));
            $element.find('input.day-of-week').on('ifChecked', function () {
                let val = $(this).val();
                list_working_day.push(val);
                $element.find(`input[name="${plugin.settings.input_name}"]`).val(JSON.stringify(list_working_day));
            });
            $element.find('input.day-of-week').on('ifUnchecked', function () {
                let val = $(this).val();
                let index = list_working_day.indexOf(val);
                list_working_day.splice(index, 1);
                $element.find(`input[name="${plugin.settings.input_name}"]`).val(JSON.stringify(list_working_day));
            });

        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_selectday = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_selectday')) {
                var plugin = new $.field_selectday(this, options);
                $(this).data('field_selectday', plugin);
            }
        });
    }
})(jQuery);