<?php

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));

$format = '<input type="radio" id="%1$s" name="%2$s" value="%3$s" %4$s />';
$alt = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $name);
?>
<fieldset id="<?php esc_html_e($id); ?>"
          class="<?php echo(trim($class . ' radio' . ($readonly || $disabled ? ' disabled' : '') . ($readonly ? ' readonly' : ''))); ?>"
	<?php echo($disabled ? 'disabled' : ''); ?>
	<?php echo($readonly || $disabled ? 'style="pointer-events: none"' : '') ?>
	<?php echo($required ? 'required aria-required="true"' : ''); ?>
	<?php echo($autofocus ? 'autofocus' : ''); ?>>
	<?php if (!empty($options)) : ?>
		<?php foreach ($options as $i => $option) : ?>
			<?php
			
			$checked = ((string)$option->value === $value) ? 'checked="checked"' : '';
			$disabled = !empty($option->disable) ? 'disabled' : '';
			$style = $disabled ? 'style="pointer-events: none"' : '';
			$option->class = !empty($option->class) ? $option->class : '';
			$option->class = trim($option->class . ' ' . $disabled);
			$optionClass = !empty($option->class) ? 'class="' . $option->class . '"' : '';
			
			$onclick = !empty($option->onclick) ? 'onclick="' . $option->onclick . '"' : '';
			$onchange = !empty($option->onchange) ? 'onchange="' . $option->onchange . '"' : '';
			$oid = $id . $i;
			$ovalue = htmlspecialchars($option->value, ENT_COMPAT, 'UTF-8');
			$attributes = array_filter(array($checked, $optionClass, $disabled, $style, $onchange, $onclick));
			?>
			<?php if ($required) : ?>
				<?php $attributes[] = 'required aria-required="true"'; ?>
			<?php endif; ?>
			<?php echo(sprintf($format, $oid, $name, $ovalue, implode(' ', $attributes))); ?>
            <label for="<?php esc_html_e($oid); ?>" <?php echo(trim($optionClass . ' ' . $style)); ?>>
				<?php esc_html_e($option->text); ?>
            </label>
		<?php endforeach; ?>
	<?php endif; ?>
</fieldset>
