<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Utilities\Utility;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.icheck');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$list_position = [
	"woocommerce_before_single_product",
	"woocommerce_before_single_product_summary",
	"woocommerce_single_product_summary",
	"woocommerce_before_add_to_cart_form",
	"woocommerce_before_add_to_cart_button",
	"woocommerce_after_add_to_cart_button",
	"woocommerce_after_add_to_cart_form",
	"woocommerce_product_meta_start",
	"woocommerce_product_meta_end",
	"woocommerce_share",
	"woocommerce_after_single_product_summary",
	"woocommerce_after_single_product",
]
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-position">
        <div class="wrapper-field-position">
            <div class="list-position">
				<?php foreach ($list_position as $position) { ?>
                    <div class="item-position item-position-<?php esc_html_e($position) ?>" data-posion="<?php esc_html_e($position) ?>">
                        <input type="radio" class="position"  name="<?php esc_html_e($name); ?>"value="<?php esc_html_e($position) ?>" <?php echo($value === $position ? ' checked ' : '') ?> />
                    </div>
				<?php } ?>
            </div>
            <div>
                <img class="img-position" src="<?php echo Factory::getRootUrlPlugin() ?>/admin/nb_apps/nb_woobooking/assets/images/woocommerce-single-product-page-hooks.png" alt="img-position" />
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/position.less');
$doc->addScriptApplySelector('.field-position','field_position',array(
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/position.jquery.js');