<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.select2');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
WpBookingPro_Html::_('jquery.increment');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$modelCountry = WoobookingModel::getInstance('countries');
$list = $modelCountry->getList();
foreach ($list as &$item) {
	$item->id = $item->countrycode;
	$item->text = $item->countryname;
}
$data = $displayData['field']->getForm()->getData();
$country_code = $data->def('country_code', $default_country_code);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-phonenumber">
        <div class="wrapper-phone-number">
            <?php if(isset($field_name_country_code) || isset($country_code)) {?>
                <input type="text" class="countries" name="<?php esc_html_e($field_name_country_code) ?>" value="<?php esc_html_e($country_code) ?>"  />
            <?php } else {?>
                <input type="text" class="countries"  />
            <?php }?>
            <input type="text" class="phone_number" name="<?php esc_html_e($name); ?>" value="<?php esc_html_e($value) ?>"  />
        </div>
    </div>
<?php

$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/phonenumber.less');
$doc->addScriptApplySelector('.field-phonenumber','field_phonenumber',array(
    "input_name"=>  $name,
    "list_country"=>  $list,
    "wpbookingpro_root_url"=>  Factory::getRootUrl(),
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/phonenumber.jquery.js');