<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/customaddress.less');
WpBookingPro_Html::_('jquery.select2');

$db = Factory::getDBO();
$query = $db->getQuery(true);
$query->select('*')
	->from(WoobookingTable::getWBTable('location'));
$list = $db->setQuery($query)->loadObjectList();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="field-custom-address">
        <div class="row">
            <div class="col-md-3"><label><?php esc_attr_e('Select address','wpbookingpro') ?></label></div>
            <div class="col-md-9">
                <select name="<?php esc_html_e($name); ?>" class="list-address">
                    <option value=""><?php esc_attr_e('Custom address','wpbookingpro') ?></option>
					<?php foreach ($list as $item) { ?>
                        <option <?php echo($value == $item->id ? ' selected ' : '') ?>
                                value="<?php esc_html_e($item->id); ?>"><?php esc_html_e($item->address); ?></option>
					<?php } ?>
                </select>
            </div>
        </div>
        <div class="wrapper-custom-address">
            <div class="row">
                <div class="col-md-12">
                    <input type="text" class="form-control custom-address" name="<?php esc_html_e($name_custom_address) ?>" placeholder="<?php esc_attr_e('Custom address','wpbookingpro') ?>"  />
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.field-custom-address','field_customaddress',array(
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/jquery.customaddress.js');
