(function ($) {
    $.field_closedate = function (element, options) {
        var defaults = {
            input_name: ""
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('input[id="close-date"]').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                timePicker: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY-MM-DD HH:mm:ss'
                },
                maxYear: '+10',
                isInvalidDate: function(date) {
                    if (date.format('YYYY-MM-DD') < moment().format('YYYY-MM-DD')) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.input_name['0']}"]`).val(start.format('YYYY-MM-DD HH:mm:ss'));
            });
            $element.find('.label').click(function (e) {
                if (!$(this).find('input[type="checkbox"]').is(':checked')) {
                    $element.addClass('hide-option');
                    $element.find('.option').removeClass('invisible');
                } else {
                    $element.removeClass('hide-option');
                    $element.find('.option').addClass('invisible');
                }
            });
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '10%'
            }).on('ifChanged ', function(event) {
                if (!$(this).is(':checked')) {
                    $element.removeClass('hide-option');
                    $element.find('.option').addClass('invisible');
                } else {
                    $element.addClass('hide-option');
                    $element.find('.option').removeClass('invisible');
                }
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_closedate = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_closedate')) {
                var plugin = new $.field_closedate(this, options);
                $(this).data('field_closedate', plugin);
            }
        });
    }
})(jQuery);