<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$categoriesModel = WoobookingModel::getInstance('categories');
$list_location = $categoriesModel->getList();
$value = is_array($value) ? $value : array($value);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-categories">
        <select name="<?php esc_html_e($name); ?>" <?php echo ($multiple ? ' multiple ' : '') ?>
                class="form-control list-category">
            <option value=""><?php esc_attr_e_('Select location','wpbookingpro') ?></option>
			<?php foreach ($list_location as $category) { ?>
                <option <?php echo(in_array($category->id, $value) ? ' selected ' : '') ?>
                        value="<?php esc_html_e($category->id); ?>"><?php esc_html_e($category->name); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingPro_Html::_('jquery.select2');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/categories.less');
$doc->addScriptApplySelector('.field-categories','field_categories',array(
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/categories.jquery.js');
