"use strict";
(function ($) {
    $.view_tool = function (element, options) {
        let defaults = {
            tool_check: [],
            step: 1
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.setup_follow_tool = function () {
            let tool_check = plugin.settings.tool_check;
            if (tool_check.length > 0) {
                let tool = tool_check.pop();
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        task: `tool.${tool}`
                    },
                    beforeSend: function () {
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        if (response.result === "success") {
                            plugin.setup_follow_tool();
                        } else {
                            $.alert({
                                title: 'Error',
                                content: response.msg
                            });
                        }
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                    },
                });
            } else {
                $.alert({
                    title: 'success',
                    content: 'completed setup tool',
                });
            }
        };
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.btn-next').click(function (e) {
                let atLeastOneIsChecked = $element.find('input.tool-item:checkbox:checked').length > 0;
                if (!atLeastOneIsChecked) {
                    $.alert({
                        title: 'Error',
                        content: 'you must less one checked',
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure do this action ?',
                    buttons: {
                        confirm: function () {
                            $element.find('form[name="admin-form"]').submit();
                        },
                        cancel: function () {
                        }
                    }
                });
                return true;
            });
            $element.find('.btn-download-package').click(function (e) {
                let link=$(this).attr('href');
                e.preventDefault();
                $.confirm({
                    title: 'Confirm',
                    content: $element.find('.notification-before-download').clone().removeClass('hide'),
                    buttons: {
                        confirm: function () {
                            window.location.href = link;
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $element.find('.list-tool input.tool-item').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            let step = plugin.settings.step;
            if (step === 2) {
                plugin.setup_follow_tool();
            }
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_tool = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_tool')) {
                let plugin = new $.view_tool(this, options);
                $(this).data('view_tool', plugin);
            }
        });
    }
})(jQuery);

