"use strict";
(function ($) {
    $.view_list_package = function (element, options) {
        let defaults = {
            row_package_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.add_new_package = function () {
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "package.ajax_add_new_package"
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);

                    loadScripts(response);
                    if (response.result === "success") {
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "package.ajax_save");
                        $wooBooking.getDrawer().drawer('toggle');
                        $wooBooking.getDrawer().find('h4.title').html('Add new package');
                        $element.find('.view-package-form').find('.package-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show')
                            $element.find('.package-tab a').removeClass('active');
                            $(this).addClass('active');
                        });
                    }
                }
            });
        }
        plugin.edit_package = function ($tr) {
            var id = $tr.data('id');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "package.ajax_get_item",
                    id: id
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);

                    loadScripts(response);
                    if (response.result === "success") {
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "package.ajax_save");
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                        $wooBooking.getDrawer().drawer('toggle');
                        $element.find('.view-package-form').find('.package-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show');
                            $element.find('.package-tab a').removeClass('active');
                            $(this).addClass('active');
                        });
                    }
                }
            });
        }
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('.btn-add-package').click(function (e) {
                e.preventDefault();
                $wooBooking.getDrawer().drawer('toggle');
            });
            $element.find('.btn-edit-order').click(function (e) {
                e.preventDefault();
                $wooBooking.getDrawer().drawer('toggle');
            });
            $element.find('.pagination-list-package').twbsPagination({
                totalPages: 35,
                visiblePages: 7,
                onPageClick: function (page) {
                    $('#page-content').text('Page ' + page);
                }
            });
            $element.find('.btn-add-new').click(function (e) {
                plugin.add_new_package();
            });
            $element.find('.btn-edit-package').live('click', function (e) {
                let $tr = $(this).closest('tr');
                plugin.edit_package($tr);
            });
            $element.find('.checked-all').click(function (e) {
                $('table.list-package').find('.checkbox-item').prop('checked', $(this).is(':checked'));
            });
            $('table.list-package').find('.checkbox-item').click(function (e) {
                var checkall = true;
                var $all_checkbox = $('table.list-package').find('.checkbox-item');
                for (let i = 0; i < $all_checkbox.length; i++) {
                    var $checkbox = $($all_checkbox[i]);
                    if (!$checkbox.is(':checked')) {
                        checkall = false;
                    }
                }
                if (checkall) {
                    $element.find('.checked-all').prop('checked', true);
                } else {
                    $element.find('.checked-all').prop('checked', false);
                }
            });
            let call_back_when_save_success = function (data) {
                var $table_list_package = $('table.list-package');
                var $row = $table_list_package.find(`tr[data-id="${data.id}"]`);
                if ($row.length)
                    $row.find('.name').html(data.name);
                else {
                    $row = $(plugin.settings.row_package_template);
                    $element.find('.list-package.main-table').find('tbody').prepend($row);
                }
            };
            $element.find('.btn-Attendees').click(function (e) {
                var id = $(this).data('id');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        action: "get_data",
                        id: id
                    },
                    success: function (response) {
                        $wooBooking.getDrawer().drawer('toggle');
                        $element.find('.view-package-form').find('.package-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show')
                        })
                    }
                });
            });
            $element.find('.btn-add-new').click(function (e) {
                var id = $(this).data('id');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        action: "get_data",
                        id: id
                    },
                    success: function (response) {
                        $wooBooking.getDrawer().find('.hy-drawer-content').html(response);
                        $wooBooking.getDrawer().drawer('toggle');
                        $element.find('.view-package-form').find('.package-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show')
                        })
                    }
                });
            });
            $element.find('.btn-delete').click(function (e) {
                let list_delete_package_id = [];
                $element.find('.checkbox-item:checked').each(function (e) {
                    list_delete_package_id.push($(this).val());
                });
                if (list_delete_package_id.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose package before delete!'
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this packge?',
                    buttons: {
                        confirm: function () {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: wpbookingpro_root_url + wpbookingpro_api_task,
                                data: {
                                    task: "package.ajax_delete",
                                    list_delete_package_id: list_delete_package_id
                                },
                                success: function (response) {
                                    location.reload(true);
                                }
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_package = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_package')) {
                let plugin = new $.view_list_package(this, options);
                $(this).data('view_list_package', plugin);
            }
        });
    }
})(jQuery);
