"use strict";
(function ($) {
    $.view_list_order_status = function (element, options) {
        let defaults = {
            row_order_status_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.add_new_order_status = function () {
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "order_status.ajax_add_new_order_status"
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    loadScripts(response);
                    if (response.result === "success") {
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $('body').append(response.data_script);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "order_status.ajax_save");
                        $wooBooking.getDrawer().drawer('toggle');
                        $element.find('.view-order-status-form').find('.order-status-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show');
                            $element.find('.order_status-tab a').removeClass('active');
                            $(this).addClass('active');
                        });
                    }
                }
            });
        }
        plugin.edit_order_status = function ($tr) {
            var id = $tr.data('id');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "order_status.ajax_get_item",
                    id: id
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    loadScripts(response);
                    if (response.result === "success") {
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $('body').append(response.data_script);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "order_status.ajax_save");
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                        let title = id !== 0 ? `Edit order status: ${id}` : 'Add new order status';
                        $wooBooking.getDrawer().find('h4.title').html(title);
                        $wooBooking.getDrawer().drawer('toggle');
                        $element.find('.view-order-status-form').find('.order-status-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show')
                            $element.find('.order-status-tab a').removeClass('active');
                            $(this).addClass('active');
                        });
                    }
                }
            });
        }
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('.pagination-list-order_status').twbsPagination({
                totalPages: 35,
                visiblePages: 7,
                onPageClick: function (order_status, page) {
                    $('#page-content').text('Page ' + page);
                }
            });
            $element.find('.btn-add-order-status').click(function (e) {
                plugin.add_new_order_status();
            });
            $element.find('.btn-edit-order-status').live('click', function (e) {
                let $tr = $(this).closest('tr');
                plugin.edit_order_status($tr);
            });
            $element.find('.checked-all').click(function (e) {
                $('table.list-order_status').find('.checkbox-item-order_status').prop('checked', $(this).is(':checked'));
            });
            $('table.list-order_status').find('.checkbox-item-order_status').click(function (e) {
                var checkall = true;
                var $all_checkbox = $('table.list-order_status').find('.checkbox-item-order_status');
                for (let i = 0; i < $all_checkbox.length; i++) {
                    var $checkbox = $($all_checkbox[i]);
                    if (!$checkbox.is(':checked')) {
                        checkall = false;
                    }
                }
                if (checkall) {
                    $element.find('.checked-all').prop('checked', true);
                } else {
                    $element.find('.checked-all').prop('checked', false);
                }
            });
            let call_back_when_save_success = function (data) {
                var $table_list_order_status = $('table.list-order_status');
                var $row = $table_list_order_status.find(`tr[data-id="${data.id}"]`);
                if ($row.length)
                    $row.find('.name').html(data.name);
                else {
                    $row = $(plugin.settings.row_order_status_template);
                    $element.find('.list-order_status.main-table').find('tbody').prepend($row);
                }
            };
            $element.find('.btn-delete').click(function (e) {
                let list_delete_order_status_id = [];
                $element.find('.checkbox-item-order-status:checked').each(function () {
                    list_delete_order_status_id.push($(this).val());
                });
                if (list_delete_order_status_id.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose order_status before delete!'
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this image in gallery ?',
                    buttons: {
                        confirm: function () {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: wpbookingpro_root_url + wpbookingpro_api_task,
                                data: {
                                    task: "order_status.ajax_delete",
                                    list_delete_order_status_id: list_delete_order_status_id
                                },
                                success: function (response) {
                                    location.reload(true);
                                }
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $wooBooking.call_back_when_save_success = function (data, is_new) {
                location.reload(true);
            }
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_order_status = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_order_status')) {
                let plugin = new $.view_list_order_status(this, options);
                $(this).data('view_list_order_status', plugin);
            }
        });
    }
})(jQuery);
