"use strict";
(function ($) {
    $.view_list_location = function (element, options) {
        let defaults = {
            row_location_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let location_id;
            $element.find('.checkmark').click(function (e) {
                let $wrapper_location_item = $(this).closest('.wrapper-location-item');
                location_id = $wrapper_location_item.data('location_id');
                let checkBoxes = $wrapper_location_item.find('.delete-location');
                checkBoxes.prop("checked", !checkBoxes.prop("checked"));
            })
            $element.find('.btn-add-location').click(function (e) {
                e.preventDefault();
                $wooBooking.getDrawer().drawer('toggle');
            });
            $element.find('.btn-edit-order').click(function (e) {
                e.preventDefault();
                $wooBooking.getDrawer().drawer('toggle');
            });
            $element.find('.pagination-list-location').twbsPagination({
                totalPages: 35,
                visiblePages: 7,
                onPageClick: function (location, page) {
                    $('#page-content').text('Page ' + page);
                }
            });
            $element.find('.btn-add-new').click(function (e) {
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        task: "location.ajax_get_item"
                    },
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        if (response.result === "success") {
                            loadScripts(response);
                            $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                            $('body').append(response.data_script);
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "location.ajax_save");
                            $wooBooking.getDrawer().drawer('toggle');
                            $wooBooking.getDrawer().find('h4.title').html('Add new location');
                            $('.view-location-form').find('.location-tab a').on('click', function (e) {
                                e.preventDefault();
                                $(this).tab('show')
                                $('.location-tab a').removeClass('active');
                                $(this).addClass('active');
                            });
                        }
                    }
                });
            });
            $element.find('.btn-location-edit').live('click', function (e) {
                var id = $(this).data('id');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        task: "location.ajax_get_item",
                        id: id
                    },
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        if (response.result === "success") {
                            loadScripts(response);
                            $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                            $('body').append(response.data_script);
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "location.ajax_save");
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                            $wooBooking.getDrawer().find('h4.title').html(`Edit location: ${id}`);
                            $wooBooking.getDrawer().drawer('toggle');
                            $('.view-location-form').find('.location-tab a').on('click', function (e) {
                                e.preventDefault();
                                $(this).tab('show')
                                $('.location-tab a').removeClass('active');
                                $(this).addClass('active');
                            });
                        } else {
                            ` $.alert({
                        title: 'Error',
                        content: response.msg
                    });`
                        }
                    }
                });
            });
            $element.find('.btn-add-new').click(function (e) {
                var id = $(this).data('id');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: wpbookingpro_root_url + "wp-json/woobooking_api/1.0/location/get_location_by_id",
                    data: {
                        action: "get_data",
                        id: id
                    },
                    success: function (response) {
                        $wooBooking.getDrawer().find('.hy-drawer-content').html(response);
                        $wooBooking.getDrawer().drawer('toggle');
                        $('.view-location-form').find('.location-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show')
                        })
                    }
                });
            });
            $element.find('.btn-delete').click(function (e) {
                let list_delete_location_id = [];
                $element.find('.delete-location:checked').each(function (e) {
                    list_delete_location_id.push($(this).val());
                });
                if (list_delete_location_id.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose location before delete!'
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this image in gallery ?',
                    buttons: {
                        confirm: function () {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: wpbookingpro_root_url + wpbookingpro_api_task,
                                data: {
                                    task: "location.ajax_delete",
                                    list_delete_location_id: list_delete_location_id
                                },
                                success: function (response) {
                                    location.reload(true);
                                }
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $wooBooking.call_back_when_save_success = function (data, is_new) {
                location.reload(true);
            }
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_location = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_location')) {
                let plugin = new $.view_list_location(this, options);
                $(this).data('view_list_location', plugin);
            }
        });
    }
})(jQuery);
