"use strict";
(function ($) {
    $.admin_main_script = function (element, options) {
        let defaults = {
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.call_back_when_save_success = function (data, is_new) {
            if (typeof plugin.settings.call_back_when_save_success === "function") {
                plugin.settings.call_back_when_save_success(data, is_new);
            }
        };
        plugin.set_class_name_drawerel = function ($class_name) {
            $element.find('#drawerEl_woo-booking').addClass($class_name);
        };
        plugin.call_back_when_duplicate_success = function (data) {
            if (typeof plugin.settings.call_back_when_duplicate_success === "function") {
                plugin.settings.call_back_when_duplicate_success(data);
            }
        };
        plugin.action_duplicate_item = function (task, id, close) {
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: task,
                    id: id
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        $.alert({
                            title: 'Success',
                            content: 'Duplicate success !',
                        });
                        plugin.call_back_when_duplicate_success(response.data);
                        if (close) {
                            $element.find('#drawerEl_woo-booking').drawer('toggle');
                        }
                    } else {
                    }
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
            });
        };
        plugin.call_back_when_delete_success = function (id, data) {
            if (typeof plugin.settings.call_back_when_delete_success === "function") {
                plugin.settings.call_back_when_delete_success(id, data);
            }
        };
        plugin.action_delete_item = function (task, id, close) {
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: task,
                    id: id
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        $.alert({
                            title: 'Success',
                            content: 'Delete success !',
                        });
                        plugin.call_back_when_delete_success(id, response.data);
                        if (close) {
                            $element.find('#drawerEl_woo-booking').drawer('toggle');
                        }
                    } else {
                    }
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
            });
        };
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);

            $element.addClass('nb-woo-booking');
            $element.find('.wrapper-woo-booking-debug').appendTo('body');
            let drawerEl = "drawerEl_woo-booking";
            let $drawer_toggle = $(`<aside id="${drawerEl}" data-prevent-default="true" 
               data-mouse-events="true">
               <div class="wraper-content">
                    <div class="top">
                        <h4 class="title">Title here</h4>
                        <a href="javascript:void(0)" class="btn-close "><i class="far fa-times-circle fa-3"></i></a>
                    </div>
                    <div class="drawerEl-content">
                    </div>
                    
                </div>
                <div class="bottom">
                        <div class="controllers">
                            <div class="pull-left" style="display: none">
                                <button class="btn btn-primary toolbar-btn-duplicate"><i class="far fa-copy"></i>&nbsp;</button>
                                <button class="btn btn-primary toolbar-btn-published"><i class="far fa-eye"></i>&nbsp;</button>
                                <button class="btn btn-primary toolbar-btn-delete"><i class="far fa-trash-alt"></i> &nbsp;</button>
                            </div>
                            <div class="pull-right">
                                <button class="btn btn-primary toolbar-btn-save"><i class="far fa-save"></i> Save</button>
                                <button class="btn btn-primary btn-cancel" type="button"><i class="far fa-times-circle"></i> Cancel</button>
                            </div>
                        </div>
                    </div>
                </aside>`);
            $drawer_toggle.appendTo($('body'));
            $element.find('#drawerEl_woo-booking').drawer({
                opened: false,
                align: 'right',
                range: [0, 100],
                persistent: true,
                preventDefault: false,
                threshold: 10,
                mouseEvents: false
            }).on('transitioned.hy.drawer', function (e) {
                let class_name = "hy-drawer-scrim-open";
                let body_class_name = "body-hy-drawer-scrim-open";
                let $element_drawer = $element.find('.hy-drawer-scrim');
                if ($element_drawer.hasClass(class_name)) {
                    $element_drawer.removeClass(class_name);
                    $('body').removeClass(body_class_name);
                } else {
                    $element_drawer.addClass(class_name);
                    $('body').addClass(body_class_name);
                }
            }).on('hy-drawer-init', function (e) {
            }).on('hy-drawer-slidestart', function (e) {
            }).on('hy-drawer-slideend', function (e) {
            });
            $element.find("#drawerEl_woo-booking").find('.btn-close').click(function (e) {
                $element.find("#drawerEl_woo-booking").drawer('toggle');
            });
            $element.find("#drawerEl_woo-booking").find('.btn-cancel').click(function (e) {
                $element.find("#drawerEl_woo-booking").drawer('toggle');
            });
            $element.find("#drawerEl_woo-booking").find('.toolbar-btn-duplicate').click(function (e) {
                let $btn = $(this);
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure duplicate this item ?',
                    buttons: {
                        confirm: function () {
                            let task = $btn.data('task');
                            let id = $btn.data('id');
                            plugin.action_duplicate_item(task, id, true);
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $element.find("#drawerEl_woo-booking").find('.toolbar-btn-delete').click(function (e) {
                let $btn = $(this);
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this item ?',
                    buttons: {
                        confirm: function () {
                            let task = $btn.data('task');
                            let id = $btn.data('id');
                            plugin.action_delete_item(task, id, true);
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $element.find("#drawerEl_woo-booking").find('.toolbar-btn-save').click(function (e) {
                if (!$element.find("#drawerEl_woo-booking").find('form').valid()) {
                    return;
                }
                let $btn = $(this);
                let main_table = $btn.data('main_table');


                let $table = $(`.${main_table}`);
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure save this item ?',
                    buttons: {
                        confirm: function () {
                            let task = $btn.data('task');
                            $element.find("#drawerEl_woo-booking").find('form').serializeObject().done(function (data) {
                                plugin.save_data(task, data, true);
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $element.find('form[name="admin-form"]').validate({
                ignore: ""
            });
            $element.find('form[name="admin-form"]').submit(function (event) {
                if (!$(this).valid()) {

                }
            });
            let $current_link_admin = $element.find(`a[href="${wpbookingpro_current_url}"]`);
            $current_link_admin.closest('li.wb_db_appointments_item').addClass('m-menu__item--open m-menu__item--active');
            $element.find('.stools-column-order').click(function (e) {
                let order = $(this).data('order');
                let $form = $(this).closest('form');
                $form.find('input[name="order"]').val(order);
                $form.submit();
            });
        };
        plugin.save_data = function (task, data, close) {
            let is_new = true;
            if (data.id) {
                is_new = false;
            }
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: task,
                    data: data
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        $.alert({
                            title: 'Success',
                            content: 'Save success !',
                        });
                        plugin.call_back_when_save_success(response.data, is_new);
                        if (close) {
                            $element.find('#drawerEl_woo-booking').drawer('toggle');
                        }
                    } else {
                    }
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
            });
        };
        plugin.getDrawer = function (response) {
            return $element.find('#drawerEl_woo-booking');
        };
        plugin.loadScripts = function (response) {
            loadScripts(response);
        };
        plugin.init();
    };
    $.fn.admin_main_script = function (options) {
        let plugin;
        if (undefined === $(this).data('admin_main_script')) {
            plugin = new $.admin_main_script(this, options);
            $(this).data('admin_main_script', plugin);
        } else {
            plugin = $(this).data('admin_main_script');
        }
        return plugin;
    }
})(jQuery);
let $woo_booking_debug = jQuery('.wrapper-woo-booking-debug').woo_booking_debug({});
let $wooBooking = jQuery('body').admin_main_script({});
let $ = jQuery;
let WooBooking = {
    submitform: function (e) {
        $('form[name="adminForm"]').submit();
    }
};
jQuery.getMultiScripts = function (arr, path) {
    var _arr = $.map(arr, function (scr) {
        return $.getScript(scr);
    });

    _arr.push($.Deferred(function (deferred) {
        $(deferred.resolve);
    }));

    return $.when.apply($, _arr);
};
jQuery.getMultiLess = function (arr, path) {
    var _arr_less = $.map(arr, function (scr) {
        let current_less = document.createElement('link');
        current_less.setAttribute('rel', 'stylesheet/less');
        current_less.setAttribute('type', 'text/css');
        current_less.setAttribute('href', scr);
        document.head.appendChild(current_less);
    });
    _arr_less.push($.Deferred(function (deferred) {
        $(deferred.resolve);
    }));
    return $.when.apply($, _arr_less);
};
let list_js_installed = [];
function loadScripts(response) {
    let $ = jQuery;
    $('link[rel="stylesheet/less"]').remove();
    var styleSheets = response.styleSheets;
    $.each(styleSheets, function (src, value) {
        if (src.indexOf('http') >= 0) {
            $('head').append(`<link rel="stylesheet" href="${src}" type="text/css" />`);
        } else {
            $('head').append(`<link rel="stylesheet" href="${wpbookingpro_root_url_plugin}${src}" type="text/css" />`);
        }


    });
    var less_arr = [];
    var lessStyleSheets = response.lessStyleSheets;
    $.each(lessStyleSheets, function (src, value) {
        if (src.indexOf('http') >= 0) {
            less_arr.push(src);
        } else {
            less_arr.push(wpbookingpro_root_url_plugin + src);
        }
    });
    $.getMultiLess(less_arr, wpbookingpro_root_url_plugin).done(function () {
        let script_arr = [];

        var scripts = response.scripts;
        $.each(scripts, function (src, value) {
            if( src.indexOf('http') >= 0){
                script_arr.push(src);
            }else{
                script_arr.push(wpbookingpro_root_url_plugin+src);
            }

        });
        $.getMultiScripts(script_arr, wpbookingpro_root_url_plugin).done(function () {
            let script = response.script;
            $('head').append(`<script  type="text/javascript">${script['text/javascript']}</script>`);
            $wooBooking.getDrawer().find('form').validate({
                ignore: ""
            });
        });
    });
}