<?php
/*
Plugin Name: Wp Salon Elements
Plugin URI: http://netbaseteam.com/
Description: Prodive all Elementor elements and widgets.
Version: 1.0.0
Author: NBTeam
Author URI: http://themeforest.net/user/netbaseteam
*/

define('TP_ELEMENTS_PATH', plugin_dir_path(__FILE__));
define('TP_ELEMENTS_NAME', plugin_basename(__FILE__));
define('TP_ELEMENTS_URL', plugin_dir_url( __FILE__ ));

class Netbase_Elements
{
    public static function init()
    {
        self::include_function_plugins();
        self::load_widget();
        add_action('wp_enqueue_scripts', array(__CLASS__, 'nb_elements_enqueue_scripts'));
        add_action( 'elementor/widgets/widgets_registered', [ __CLASS__, 'register_widgets' ] );
        add_action( 'elementor/elements/categories_registered', [ __CLASS__, 'add_elementor_widget_categories' ] );
    }

    public static function nb_elements_enqueue_scripts() {

        wp_enqueue_style( 'swiper', TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.css', array(), '5.3.7');
        wp_enqueue_script( 'swiper',  TP_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.js', array('jquery'), '5.3.7', true);
        
        wp_enqueue_style( 'nb_elements', TP_ELEMENTS_URL . 'assets/css/main.css', array(), '20180324' );
        if(is_rtl()){
            wp_enqueue_style( 'nb_elements_rtl', TP_ELEMENTS_URL . 'assets/rtl.css', array(), '20180324' ); 
        }
        wp_enqueue_script( 'nb_elements', TP_ELEMENTS_URL . 'assets/js/main.js', array( 'jquery' ), '20180324', true );


        wp_enqueue_script( 'equal_height', TP_ELEMENTS_URL . 'assets/vendors/jquery-match-height/jquery.matchHeight-min.js', array(), '0.7.2', true );
        wp_enqueue_script( 'imageload', TP_ELEMENTS_URL . 'assets/vendors/imagesloaded/imagesloaded.pkgd.min.js', array(), '4.1.4', true );
        wp_enqueue_script( 'isotope', TP_ELEMENTS_URL . 'assets/vendors/isotope/isotope.pkgd.min.js', array(), '3.0.6', true );

        wp_enqueue_style( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/magnific-popup.css', array(), '1.1.0' );
        wp_enqueue_script( 'magnific-popup', TP_ELEMENTS_URL . 'assets/vendors/magnific-popup/jquery-magnific-popup.min.js', array('jquery'), '1.1.0', true );
        
        

    }
    
    public static function include_function_plugins() {

        if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
    }

    public static function load_widget() {
        require_once( TP_ELEMENTS_PATH . 'widgets/social-links.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/contact-info.php' );
        require_once( TP_ELEMENTS_PATH . 'widgets/recent-blog.php' );
    }

    public static function register_widgets() {
		self::include_widgets_files();
    }
    
    public static function include_widgets_files() {
		require_once( TP_ELEMENTS_PATH . 'elementor_widgets/blog/blog.php' );
		require_once( TP_ELEMENTS_PATH . 'elementor_widgets/testimonials/testimonials.php' );
    }
    
    public static function add_elementor_widget_categories( $elements_manager ) {

		$elements_manager->add_category(
			'spaclub-elements',
			[
				'title' => __( 'Spaclub', 'spaclub-elements' ),
				'icon' 	=> 'fa fa-plug',
			]
		);
	}
}
Netbase_Elements::init();
