<?php
/**
 * Plugin Name: WordPress Appointment Booking & Scheduling with Woocommerce
 * Plugin URI: http://demo12.cmsmart.net/wp_booking_pro/
 * Description: WordPress Booking Appointment Pro is a plugin developed for appointment.
 * Version: 1.1.5
 * Author: NetBase Team
 * Author URI: https://codecanyon.net/item/wp-appointment/26587538
 * Text Domain: wpbookingpro
**/

use WpBookingPro\Application\Application as ApplicationAlias;
use WpBookingPro\Factory as FactoryAlias;

if(!defined('DS')) {
    define("DS",DIRECTORY_SEPARATOR);
}
if (!defined("WPBOOKINGPRO_PLUGIN_NAME")) {
    define('WPBOOKINGPRO_PLUGIN_NAME', pathinfo(__DIR__, PATHINFO_FILENAME));
}
define("WPBOOKINGPRO_PATH_ROOT",plugin_dir_path(__FILE__));
define("_WPBOOKINGPRO_EXEC",1);
define("WPBOOKINGPRO_PREFIX_TABLE","woobooking_");
define("WPBOOKINGPRO_MINIMUM_ELEMENTOR_VERSION","2.0.0");
define("WPBOOKINGPRO_MINIMUM_PHP_VERSION","7.0");
define("WPBOOKINGPRO_ADMIN_PATH",WPBOOKINGPRO_PATH_ROOT.DS."admin");
define("WPBOOKINGPRO_ADMIN_WOOPANEL_PATH",WPBOOKINGPRO_PATH_ROOT.DS."admin_woopanel");
define("WPBOOKINGPRO_FRONTEND_PATH",WPBOOKINGPRO_PATH_ROOT.DS."frontend");
define("WPBOOKINGPRO_PLUGIN_DIR_URL",plugin_dir_url(__FILE__));
define("WPBOOKINGPRO_SITE_URL",get_site_url());
require_once WPBOOKINGPRO_PATH_ROOT.DS."wpbookingproconfig.php";
require_once WPBOOKINGPRO_PATH_ROOT.DS."NBAppHelper.php";
// Check for required Elementor version
if(file_exists(ABSPATH . 'wp-content/plugins/elementor/elementor.php'))
{
    include_once( ABSPATH . 'wp-content/plugins/elementor/elementor.php' );
}

/**
 * Class wpbookingpro
 */
class wpbookingpro
{

//    function service_op_generate_rewrite_rules( $wp_rewrite ){
//
//        $wp_rewrite->rules = array_merge(
//            ['service-detail/-53.html' => 'index.php?p=24'],
//            $wp_rewrite->rules
//        );
//    }

    public static function init()
    {

        $url="https://developer.wordpress.org/reference/functions/wp_redirect/";
        require_once __DIR__."/vendor/autoload.php";
        $input= FactoryAlias::getInput();
        $clientId=is_admin()?1:0;
        //check is admin woopanel
        $data=$input->getData();
        $uri= FactoryAlias::getUri();
        $path=$uri->getPath();
        if(strpos($path,"wpbookingpro_backend")!==false){
            $clientId=1;
        }
        $submit_clientId=$input->getString('submit_clientid',"");
        if($submit_clientId!==""){
            $clientId=(int)$submit_clientId;
        }
        $page="";
        if(strpos($path,"sellercenter")!==false || strpos($path,"wpbookingpro_backend_woopanel")!==false){
            $clientId=2;
            $paths=explode('/',$path);
            foreach ($paths as $a_path){
                if(strpos($a_path,"wb_")!==false){
                    $page=str_replace("wb_","",$a_path);
                }
            }

        }
        $input->set('woopanel_page',$page);
        if($clientId==2){
            require_once __DIR__."/admin_woopanel/includes/defined.php";
        }elseif($clientId==1){
            require_once __DIR__."/admin/includes/defined.php";
        }else{
            require_once __DIR__."/frontend/includes/defined.php";
        }
        FactoryAlias::setApplicationClient($clientId);
        $app=ApplicationAlias::getInstance($clientId);
        $app->execute();


    }

}

wpbookingpro::init();
if(!function_exists("wpbookingpro_get_content")) {
    function wpbookingpro_render_content($content)
    {
        echo (wpbookingpro_get_content($content));
    }
}
if(!function_exists("wpbookingpro_get_content")) {
    function wpbookingpro_get_content($content)
    {
        return $content;
    }
}