<?php
namespace WpBookingPro\Wordpress;

use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Filesystem\File;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingPro\Log\Log;
use WpBookingPro\Mvc\Controller\Controller;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
use WpBookingPro\Wordpress\ECommerce\ECommerce;

/**
 * Class Wordpress
 * @package WpBookingPro\Wordpress
 */
class WordpressSite extends Wordpress
{

    /**
     * @var
     */
    private static $instance;
    public static $key_woo_booking = "woobooking";
    public static $prefix_link = "wb_";
    /**
     * @var string
     */
    public static $namespace = "wpbookingpro_api/1.0";
    private static $parsed_route=false;
    /**
     * @var int
     */
    private $clientId=0;
    private $init_GutembergBlock=0;
    public function init(){

        add_action( 'wp_ajax_action_ajax_by_task', array($this,'wp_appointment_action_ajax_by_task') );
        add_action( 'wp_ajax_nopriv_action_ajax_by_task',   array($this,'wp_appointment_action_ajax_by_task') );
        add_filter( 'wp_title', array($this,'theme_slug_filter_wp_title' ));

        if(!$this->is_admin()) {
            if(session_id() == '')
                session_start();
            add_action( 'woopanel_menus', array($this,'add_menu_to_woopanel') );
            add_filter( 'woopanel_submenus', array( $this, 'add_sub_menu_to_woopanel') );
            add_filter( 'woopanel_vendor_query_var', array( $this, 'woopanel_query_var_filter') );

            $list_view_for_woo_panel=WordpressAdmin::get_list_view_for_woo_panel();

            foreach ($list_view_for_woo_panel as $menu){
                $menu=(object)$menu;
                add_action( "woopanel_dashboard_{$menu->id}_endpoint", array($this,'render_page_by_endpoint_woopanel') );
            }

            add_action( 'wp_enqueue_scripts', array($this,'wp_enqueue_scripts') );
            $input=Factory::getInput();
            $data=$input->getData();

            if(isset($data['_locale'])){
                return false;
            }
            $task=$input->getString('task',"");
            if ($task) {
                list($controller, $task) = explode(".", $task);
                $class_name ="WpBookingProFrontend\app\\controllers\\". ucfirst($controller) . "Controller";
                if (class_exists($class_name)) {
                    $class_controller = new $class_name();
                    if (method_exists($class_controller, $task)) {
                        //not return
                        call_user_func(array($class_controller, $task));

                    }
                }
            }

            add_action( 'init', array( $this, 'load_plugin_textdomain' ) );
            WpBookingProHtmlFrontend::load_jquery_library('less');
            WpBookingProHtmlFrontend::load_jquery_library('main_app');
            WpBookingProHtmlFrontend::load_jquery_library('lazy_load');
            WpBookingProHtmlFrontend::load_jquery_library('bootstrap');

            $path = "wp-content/plugins/wpbookingpro/frontend/app/views.xml";
            add_shortcode('wpbookingpro', array($this, "front_end_render_view"));
            add_action('rest_api_init', array($this, 'wp_register_rest_route'));
            $list_view = $this->get_list_layout_block_frontend();

            foreach ($list_view as $key => $view) {
                $a_key = self::$key_wpbookingpro . "-block-" . $key;
                add_shortcode($a_key, array($this, 'woo_booking_render_block_by_tag_func'));
            }
            add_action( 'wp_head', array($this,'gretathemes_meta_description'));
            add_filter('pre_get_document_title',array($this,'add_title_for_service'),10, 3 );

            $gutembergBlock = GutembergBlock::getInstance();
            $gutembergBlock->init();
            $widgets = Widgets::getInstance();
            $widgets->init();

            $eCommerce = ECommerce::getInstance();
            $eCommerce->init();
            add_action('wp_footer', array($this, 'wp_hook_add_script_footer'));
            add_filter( 'init', array($this,"service_op_generate_rewrite_rules"));
        }



    }

    function add_title_for_service(){
        $title="";
        $this->parse_route();
        $input = Factory::getInput();

        $service_id = $input->getInt('service_id',0);
        $modelService= Model::getInstance('service');
        $service=$modelService->getItem($service_id);
        if(isset($service->id)) {
            $title=$service->name;
        }
        return $title;
    }
    public function parse_route(){

        if(!static::$parsed_route) {
            $input = Factory::getInput();
            $uri = Factory::getUri();
            $app = Factory::getApplication(0);
            $_router = $app->getRouter(0);
            $vars = $_router->parse($uri);
            foreach ($vars as $key => $value) {
                $input->set($key, $value);
            }
        }
    }
    function gretathemes_meta_description() {
        $this->parse_route();
        $input = Factory::getInput();
        $service_id = $input->getInt('service_id',0);
        $modelService=Model::getInstance('service');
        $content="";

        $service=$modelService->getItem($service_id);
        if(isset($service->id)) {
            ob_start();
            ?>
            <meta name="description" content="<?php esc_attr_e($service->meta_description) ?>"/>
            <meta name="keyword" content="<?php esc_attr_e($service->meta_keyword) ?>"/>

            <?php
            $content = ob_get_clean();
        }
        echo $content;
    }
    public function service_op_generate_rewrite_rules()
    {
        $wordpress=Factory::getWordpress(0);
        if(!$wordpress->checkInstalled()) { return; }
        parent::service_op_generate_rewrite_rules();

    }


    public function theme_slug_filter_wp_title( $title ) {
        if ( is_404() ) {
            $title = 'ADD 404 TITLE TEXT HERE';
        }
        // You can do other filtering here, or
        // just return $title
        return $title;
    }

    public static function add_menu_to_woopanel($woopanel_menus){
        $woopanel_menus[4]=array(
            "id"=>"wp_appointment",
            "menu_slug"=>"wp_appointment",
            "menu_title"=>"wp appointment",
            "capability"=>"",
            "page_title"=>"wp appointment",
            "icon"=>"flaticon-line-graph",
            "classes"=>"wp-appointment",
            "permission"=>"global",
        );

       return $woopanel_menus;

    }
    public static function checkInstalled()
    {
        $app = Factory::getApplication(1);
        $db = Factory::getDBO();
        $installed = true;
        $list_table_in_database = $db->setQuery("SHOW TABLES LIKE " . $db->quote("woobooking\\_%"))->loadColumn();
        if (count($list_table_in_database) == 0) {
            $installed = false;
        }
        $json_table_need_install = File::read(WPBOOKINGPRO_PATH_ROOT . "/install/tables.json");

        $json_table_need_install = json_decode($json_table_need_install);

        foreach ($json_table_need_install as $need_table) {
            if (!in_array($need_table, $list_table_in_database)) {
                $installed = false;
                break;
            }
        }

        return $installed;
    }
    private static function get_true_menu_of_woo_booking($menu)
    {
        return str_replace(self::$prefix_link, "", $menu);
    }
    public static function goToPopupInstall()
    {
        $root_url = Factory::getRootUrl();
        $html = '<html><head>';
        $html .= '<meta http-equiv="content-type" content="text/html; charset=utf-8" />';
        $html .= '<script>document.location.href=' . json_encode(str_replace("'", '&apos;',
                $root_url . '/wp-admin/admin.php?page=wb_config&layout=install')) . ';</script>';
        $html .= '</head><body></body></html>';
        echo ($html);
    }



    public static function add_sub_menu_to_woopanel($woopanel_submenus){
        $list_view_for_woo_panel=WordpressAdmin::get_list_view_for_woo_panel();

        $woopanel_submenus['wp_appointment']=($list_view_for_woo_panel);
       return $woopanel_submenus;

    }
    public function woopanel_query_var_filter( $query_vars ) {
        $list_view_for_woo_panel=WordpressAdmin::get_list_view_for_woo_panel();
        foreach ($list_view_for_woo_panel as $menu){
            $menu=(object)$menu;
            $query_vars[] = $menu->id;
        }
        return $query_vars;
    }



    public static function wp_appointment_action_ajax_by_task(){
        $input = Factory::getInput();
        $task=$input->getString("task","");
        if ($task) {
            list($controller, $task) = explode(".", $task);
            $class_name ="WpBookingProFrontend\app\\controllers\\". ucfirst($controller) . "Controller";
            if (class_exists($class_name)) {
                $class_controller = new $class_name();
                if (method_exists($class_controller, $task)) {
                    //not return
                    call_user_func(array($class_controller, $task));

                }
            }
        }
    }

    /**
     * start session
     */
    function session_start() {
        echo "hello session_start";
        die;
        if(!session_id()) {

            session_start();

        }

    }
    public static function wp_enqueue_scripts(){
        $config=Factory::getConfig();
        $environment=$config->get('environment',"development");
        if($environment=="production") {
            wp_enqueue_style( 'wpbookingpro-main-frontend-style', WPBOOKINGPRO_PLUGIN_DIR_URL . '/frontend/app/assets/less/style.css', array());
        }else{

        }


    }
    public function wp_register_rest_route(){
        register_rest_route(
            self::$namespace,
            "wpbookingpro_frontend/task",
            array(
                'methods' => 'POST',
                'callback' => array($this, 'ajax_action_task'),
            )
        );
        register_rest_route(
            self::$namespace,
            "wpbookingpro_frontend/task",
            array(
                'methods' => 'GET',
                'callback' => array($this, 'ajax_action_task'),
            )
        );
        register_rest_route(
            self::$namespace,
            "wpbookingpro_backend/task",
            array(
                'methods' => 'POST',
                'callback' => array($this, 'ajax_action_task'),
            )
        );
        register_rest_route(
            self::$namespace,
            "wpbookingpro_backend/task",
            array(
                'methods' => 'GET',
                'callback' => array($this, 'ajax_action_task'),
            )
        );
    }

    public  function load_plugin_textdomain(){
        load_plugin_textdomain( 'wpbookingpro', false, WPBOOKINGPRO_PATH_ROOT . '/languages/' );
    }

    function woo_booking_render_block_by_tag_func($atts, $content, $a_view)
    {

        $input = Factory::getInput();
        if (is_array($atts) && $id = reset($atts)) {

            list($package, $block, $block_name) = explode("-", $a_view);

            wp_kses(Controller::view_block_module($id, $block_name),true);
        }
        return false;
    }
    public function getKeyWooBooking()
    {
        return self::$key_woo_booking;
    }

    public static function get_api_task()
    {
        return "wpbookingpro_frontend/task";

    }
    public function front_end_render_view($params,$option,$view){
        $input=Factory::getInput();
        $page = $input->getString('page', '');
        $layout=$input->getString('layout',"");
        if($page=="wb_config"){
            if($layout!=="install" && !self::checkInstalled()){
                self::goToPopupInstall();
                return;
            }
        }elseif(!self::checkInstalled()){
            self::goToPopupInstall();
            return;
        }
        $task=$input->getString('task',"");
        if ($task) {
            list($controller, $task) = explode(".", $task);
            $class_name ="WpBookingProFrontend\app\\controllers\\". ucfirst($controller) . "Controller";
            if (class_exists($class_name)) {
                $class_controller = new $class_name();
                if (method_exists($class_controller, $task)) {
                    //not return
                    call_user_func(array($class_controller, $task));

                }
            }
            return;
        }

        WpBookingProHtmlFrontend::load_jquery_library('bootstrap');
        $view=isset($params['view'])?$params['view']:"services-list";
        $a_view=$input->getString('view',"");
        if($a_view){
            $view=$a_view;
        }
        list($view, $layout) = explode("-", $view);

        echo (Controller::view("$view.$layout"));
        add_action('wp_footer', array($this, 'wp_hook_add_script_footer'));

    }
    public function wp_hook_add_script_footer(){
        global $wp;

        wp_enqueue_script("jquery");

        $doc = Factory::getDocument();

        $lessStyleSheets = $doc->getLessStyleSheets();
        $config=Factory::getConfig();

        $environment=$config->get('environment',"development");
        if($environment=="development") {
            foreach ($lessStyleSheets as $src=>$item) {
                ob_start();
                ?>
                <link rel="stylesheet/less" type="text/css"
                      href="<?php  Text::_echo(WPBOOKINGPRO_PLUGIN_DIR_URL . "/" . $src) ?>"/>
                <?php
                echo (ob_get_clean());
            }
        }else{
            //$doc->addStyleSheet('frontend/app/assets/less/style.css');
        }
        $styleSheets = $doc->getStyleSheets();
        foreach ($styleSheets as $src=>$item) {
            $random = random_int(100000, 900000);
            if (strpos($src, 'http') !== false) {
                wp_enqueue_style('wpbookingpro-css-' . $random, $src);
            } else {
                wp_enqueue_style('wpbookingpro-css-' . $random, WPBOOKINGPRO_PLUGIN_DIR_URL . '/' . $src);
            }
        }

        ob_start();
        ?>
        <script type="text/javascript">
            var wpbookingpro_root_url = "<?php  echo (WPBOOKINGPRO_SITE_URL) ?>";
            var wpbookingpro_current_url = "<?php  echo (WPBOOKINGPRO_SITE_URL) ?>";
            var wpbookingpro_root_url_plugin = "<?php echo (WPBOOKINGPRO_PLUGIN_DIR_URL); ?>/";
            var wpbookingpro_api_task = "/wp-json/<?php echo (self::$namespace.'/'.$this->get_api_task()) ?>";
        </script>
        <?php
        $content=ob_get_clean();
        $content= Utility::remove_string_javascript($content);
        wp_enqueue_script('wpbookingpro-js-init', WPBOOKINGPRO_PLUGIN_DIR_URL .'frontend/resources/init.js' );
        wp_add_inline_script('wpbookingpro-js-init', $content);

        $scripts = $doc->getScripts();
        foreach ($scripts as $src =>$item){
            try {
                $random = random_int(100000, 900000);
                if (strpos($src, 'http') !== false || strpos($src, 'https') !== false) {
                    wp_enqueue_script('wpbookingpro-js-out-site'.$random,$src,array('jquery') );
                } else {
                    $src=WPBOOKINGPRO_PLUGIN_DIR_URL . $src;
                    wp_enqueue_script('wpbookingpro-js-in-site-'.$random, $src,array('jquery') );
                }
            } catch (Exception $e) {
            }

        }
        wp_enqueue_script('wpbookingpro-js-defined', WPBOOKINGPRO_PLUGIN_DIR_URL .'frontend/resources/define.js' );
        $doc=Factory::getDocument();
        $script = $doc->getScript();
        foreach ($script as $content) {
            wp_add_inline_script('wpbookingpro-js-defined', $content);
        }
    }



}