<?php
namespace WpBookingPro\Html;
use WpBookingPro\Factory;

/**
 * Class WpBookingProHtmlFrontend
 * @package WpBookingPro\Html
 */
class WpBookingProHtmlWooPanel
{
    /**
     * @var array
     */
    private static $loaded=array();

    /**
     * @param $key
     */
    public static function load_jquery_library($key)
    {
        static::call($key);
    }
    public static function content_edit_table($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/Content-editable/src/jquery-contenteditable.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    public static function loading_js($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/Fullscreen-Loading-Modal-Indicator/css/jquery.loadingModal.min.css');
            $doc->addScript('admin/resources/Fullscreen-Loading-Modal-Indicator/js/jquery.loadingModal.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    public static function auto_numeric($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin_woopanel/resources/autoNumeric/autoNumeric.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function lazy_load()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("frontend/resources/jquery.lazy/jquery.lazy.js");
            static::$loaded[__METHOD__] = true;
        }
    }

    public static function ckeditor()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("admin_woopanel/resources/ckeditor_4.14.1_full/ckeditor/ckeditor.js");
            static::$loaded[__METHOD__] = true;
        }
    }

    public static function dateselect($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/DateSelect/css/jquery.dateselect.css');
            $doc->addScript('admin/resources/DateSelect/js/jquery.dateselect.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }
    /**
     *
     */
    public static function datatables()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js");
            $doc->addStyleSheet('https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css');
            $doc->addStyleSheet('https://cdn.datatables.net/1.10.20/css/dataTables.bootstrap4.min.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    public static function twbs_pagination($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/twbs-pagination/jquery.twbsPagination.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function main_app()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScriptApplySelector('body', 'view_main_app', array(), 'admin_woopanel/app/assets/js/view_main_app.js');
            $doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_main_app.less');
            static::$loaded[__METHOD__] = true;
        }
    }

    public static function fullcalendar($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/fullcalendar/core/main.min.css');
            $doc->addStyleSheet('admin/resources/fullcalendar/daygrid/main.min.css');
            $doc->addStyleSheet('admin/resources/fullcalendar/timegrid/main.min.css');
            $doc->addStyleSheet('admin/resources/fullcalendar/bootstrap/main.min.css');
            $doc->addScript('https://jakubroztocil.github.io/rrule/dist/es5/rrule.js');
            $doc->addScript('admin/resources/fullcalendar/core/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/daygrid/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/timegrid/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/bootstrap/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/interaction/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/moment/main.min.js');
            $doc->addScript('https://unpkg.com/@fullcalendar/rrule@4.3.0/main.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }


    /**
     *
     */
    public static function bootstrap()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("admin_woopanel/resources/bootstrap3.3.7/bootstrap.min.js");
            $config=Factory::getConfig();
            $environment=$config->get('environment',"development");
            if($environment=="development") {
                $doc->addStyleSheet('admin_woopanel/resources/bootstrap3.3.7/bootstrap.min.css');
            }
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function awesome()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/fontawesome-free-5.12.1/css/all.min.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    public static function increment($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/jquery-Increment/dist/js/handleCounter.js');
            $doc->addStyleSheet('frontend/resources/jquery-Increment/dist/css/handle-counter.min.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }
    public static function chart_js($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin_woopanel/resources/Chart_js/Chart.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }
    public static function bootstrap_tabs($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin_woopanel/resources/Bootstrap-Tabs/jquery.responsivetabs.js');
            $doc->addScript('admin_woopanel/resources/Bootstrap-Tabs/bootstrap4/jquery.responsivetabs.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function ui()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript('admin/resources/jquery-ui-1.11.3/jquery-ui.js');
            $doc->addStyleSheet('admin/resources/jquery-ui-1.11.3/jquery-ui.css');
            static::$loaded[__METHOD__] = true;
        }
    }
    /**
     *
     */
    public static function starrr()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript('frontend/resources/starrr-gh-pages/dist/starrr.js');
            $doc->addStyleSheet('frontend/resources/starrr-gh-pages/dist/starrr.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     *
     */
    public static function confirm()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/jquery-confirm-master/dist/jquery-confirm.min.css');
            $doc->addScript('frontend/resources/jquery-confirm-master/dist/jquery-confirm.min.js');
            static::$loaded[__METHOD__] = true;
        }
    }


    /**
     * @param null $debug
     */
    public static function daterangepicker($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/daterangepicker-master/daterangepicker.css');
            $doc->addScript('frontend/resources/daterangepicker-master/daterangepicker.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function fontawesome($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/fontawesome-free-5.12.1/css/all.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    public static function datepickertime($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/bootstrap-datetimepicker-master/css/bootstrap-datetimepicker.min.css');
            $doc->addScript('frontend/resources/bootstrap-datetimepicker-master/js/bootstrap-datetimepicker.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function less()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/less/less.min.js');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     * @param null $debug
     */
    public static function moment($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/daterangepicker-master/moment.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function select2($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/select2-4.0.12/dist/js/select2.full.min.js');
            $doc->addStyleSheet('frontend/resources/select2-4.0.12/dist/css/select2.min.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function ionrangeSlider($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/ion.rangeSlider-master/js/ion.rangeSlider.js');
            $doc->addStyleSheet('frontend/resources/ion.rangeSlider-master/css/ion.rangeSlider.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function icheck($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/icheck-1.x/icheck.min.js');
            $doc->addStyleSheet('frontend/resources/icheck-1.x/skins/all.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function owlcarousel2()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("frontend/resources/OwlCarousel2-2.3.4/dist/owl.carousel.min.js");
            $doc->addStyleSheet('frontend/resources/OwlCarousel2-2.3.4/dist/assets/owl.carousel.min.css');
            static::$loaded[__METHOD__] = true;
        }
    }
    public static function slick()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("frontend/resources/slick/slick.js");
            $doc->addStyleSheet('frontend/resources/slick/slick.css');
            $doc->addStyleSheet('frontend/resources/slick/slick-theme.css');
            static::$loaded[__METHOD__] = true;
        }
    }
    /**
     *
     */
    public static function tooltip()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     * @param null $debug
     */
    public static function debug($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/app/assets/js/woo_booking_debug.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }


    /**
     * @param $function
     */
    protected static function call($function)
    {
        call_user_func(array("WpBookingPro\Html\WpBookingProHtmlWooPanel",$function));
    }
    public static function validate($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/jquery-validation/dist/jquery.validate.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }
}