<?php
namespace WpBookingPro\Html;

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;

/**
 * Class ToolBar
 * @package WpBookingPro\Html
 */
class ToolBar
{
    /**
     * @var array
     */
    public static $list_button=array();
    /**
     * @var
     */
    private static $title;
    /**
     * @var string
     */
    private static $layout_edit="form";

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function save($task="save", $icon="icon-nb-save", $alt="Save", $tooltip="save")
    {
        ob_start();
        ?>
        <button class="btn btn-primary btn-wpbooking-pro-submit btn-save" type="button"  data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function apply($task="apply", $icon="icon-nb-apply", $alt="Apply", $tooltip="Apply")
    {
        ob_start();
        ?>
        <button class="btn btn-primary btn-wpbooking-pro-submit btn-apply" type="button"  data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function add($task="add", $icon="icon-nb-plus", $alt="Add", $tooltip="Add")
    {
        ob_start();
        ?>
        <button class="btn btn-info btn-wpbooking-pro-submit btn-add"  type="button"  data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }
    public static function add_payment($task="add_payment", $icon="icon-nb-plus", $alt="Add", $tooltip="Add")
    {
        ob_start();
        ?>
        <button class="btn btn-info btn-wpbooking-pro-submit btn-add"  type="button"  data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param bool $must_select
     * @param string $class_checkbox
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     * @return false|string
     */
    public static function edit($task="edit", $must_select=true, $class_checkbox="item", $icon="icon-nb-edit", $alt="Edit", $tooltip="Edit")
    {
        ob_start();
        ?>
        <button class="btn btn-info btn-wpbooking-pro-submit btn-edit" data-class_checkbox="<?php echo ($class_checkbox) ?>"  type="button" data-must_selected="<?php echo ($must_select?1:0); ?>" data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        return $content;
    }

    /**
     * @param $task
     * @param $alt
     * @param string $tooltip
     * @param string $icon
     * @return false|string
     */
    public static function render_button_task($task, $alt, $tooltip="", $icon="icon-nb-plus")
    {
        ob_start();
        ?>
        <button class="btn btn-info btn-wpbooking-pro-submit"   type="button" data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        return $content;
    }

    /**
     * @param string $task
     * @param bool $must_select
     * @param string $class_checkbox
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function delete($task="delete_list", $must_select=true, $class_checkbox="item", $icon="icon-nb-delete", $alt="Delete", $tooltip="Delete")
    {
        $msg="Are you sure you want this action ?";
        ob_start();
        ?>
        <button class="btn btn-danger btn-wpbooking-pro-submit btn-delete" data-class_checkbox="<?php echo ($class_checkbox) ?>"  type="button" data-must_selected="<?php echo ($must_select?1:0); ?>" data-msg_config="<?php esc_attr_e($msg); ?>" type="button" data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param bool $must_select
     * @param string $class_checkbox
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function _clone($task="clone_list", $must_select=true, $class_checkbox="item", $icon="icon-nb-clone", $alt="Clone", $tooltip="Clone")
    {
        $msg="Are you sure you want this action ?";
        ob_start();
        ?>
        <button class="btn btn-danger btn-wpbooking-pro-submit btn-clone" data-class_checkbox="<?php echo ($class_checkbox) ?>"  type="button" data-must_selected="<?php echo ($must_select?1:0); ?>" data-msg_config="<?php esc_attr_e($msg); ?>" type="button" data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function cancel($task="cancel", $icon="icon-nb-cancel", $alt="Cancel", $tooltip="Cancel")
    {

        ob_start();
        ?>
        <button class="btn btn-danger btn-wpbooking-pro-submit btn-cancel" data-task="<?php esc_attr_e($task); ?>" type="button"  title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function back_to_list($task="back_to_list", $icon="icon-nb-back", $alt="Back", $tooltip="Back")
    {
        ob_start();
        ?>
        <button class="btn btn-danger btn-wpbooking-pro-submit btn-back-to-list" data-task="<?php esc_attr_e($task); ?>" type="button"  title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param $title
     */
    public static function setTitle($title){
        static::$title=$title;
    }

    /**
     * @return false|string
     */
    public static function render_toolbar(){
        $list=self::$list_button;
        ob_start();
        ?>
        <div class="toolbar">
            <div class="row">
                <div class="col-md-12">
                    <div class="wrapper-toolbar">
                        <div class="title"><h3 class="title"><?php esc_html_e(static::$title) ?></h3></div>
                        <div class="controllers">
                            {content}
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php
        $content=ob_get_clean();
        $content=str_replace('{content}',implode(" ",$list),$content);
        self::$list_button[]=$content;
        return $content;
    }

    /**
     * @param string $layout
     */
    public static function setLayoutEdit(string $layout)
    {
        static::$layout_edit=$layout;
    }
}