<?php
/**
 * @package     woobooking.Platform
 * @subpackage  Form
 *
 *  Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
namespace WpBookingPro\Form\fields;
defined('_WPBOOKINGPRO_EXEC') or die;
use WpBookingPro\Form\FormField;

/**
 * Form Field class for the woobooking Platform.
 * Supports a one line text field.
 *
 * @link   http://www.w3.org/TR/html-markup/input.text.html#input.text

 */
class WpBookingPro_FormFieldCalendardatetime extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'calendardatetime';
    /**
     * Name of the layout being used to render the field
     *
     * @var    string
     */
    protected $layout = 'WooBooking.form.field.calendardatetime.calendardatetime';

    protected function getLayoutData()
    {
        $data = parent::getLayoutData();

        $extraData = array(
            'field_name_is_recurring'   => $this->element['field_name_is_recurring'],
            'field_name_type_recurring'   => $this->element['field_name_type_recurring'],
            'field_name_time_take_place'   => $this->element['field_name_time_take_place'],
            'field_name_day_of_week'   => $this->element['field_name_day_of_week'],
            'field_name_day_of_month'   => $this->element['field_name_day_of_month'],
            'field_name_month_of_year'   => $this->element['field_name_month_of_year'],
            'field_name_comment_addition'   => $this->element['field_name_comment_addition'],
            'field_name_date_start_recurring'   => $this->element['field_name_date_start_recurring'],
            'field_name_time_start_recurring'   => $this->element['field_name_time_start_recurring'],
            'field_name_date_end_recurring'   => $this->element['field_name_date_end_recurring'],
            'field_name_time_end_recurring'   => $this->element['field_name_time_end_recurring'],
            'field_name_number_week_recurring'   => $this->element['field_name_number_week_recurring'],
            'field_name_number_month_recurring'   => $this->element['field_name_number_month_recurring'],
        );

        return array_merge($data, $extraData);
    }

}
