<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
$list_service=$list[0]->list_service;
$service_start=$list_service[0];
$five_service_after=array_slice($list_service,1,5,false);
$page_service_detail = ConfigHelperAlias::get_page_service_detail();
$this->page_service_detail = get_page_link($page_service_detail);
?>
    <div class="block-servicebycategory-default">
        <div class="group-tabs">
            <ul class="nav nav-tabs">
                <li role="presentation" class="active"><a href="#<?php esc_html_e($service_start->id);?>" aria-controls="<?php esc_html_e($service_start->id);?>" role="tab" data-toggle="tab"><?php esc_html_e($service_start->name);?></a></li>
                <?php foreach ($five_service_after as $service){?>
                    <li role="presentation"><a href="#<?php esc_html_e($service->id);?>" aria-controls="<?php esc_html_e($service->id);?>" role="tab" data-toggle="tab"><?php esc_html_e($service->name);?></a></li>
                <?php } ?>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="<?php esc_html_e($service_start->id);?>">
                    <div class="image">
                        <img src="<?php esc_html_e(Factory::getRootUrlPlugin())?>/<?php esc_html_e($service_start->image) ?>" alt="category-image" />
                    </div>
                    <div class="information">
                        <div class="name">
                            <h2><?php esc_html_e($service_start->name) ?></h2>
                        </div>
                        <div class="description">
                            <?php
                            $description=$service_start->description;
                            if(strlen($description)>110){?>
                                <p title="<?php esc_html_e($description) ?>"><?php esc_html_e(substr($description,0,110)) ?><?php esc_attr_e('...', 'wpbookingpro') ?></p>
                            <?php } else { ?>
                                <p><?php esc_html_e($description) ?></p>
                            <?php }
                            ?>
                        </div>
                        <div class="browse">
                            <a class="div-link" href="<?php echo($this->page_service_detail.'?service_id='.$service_start->id); ?>"><?php esc_attr_e('Link', 'wpbookingpro') ?></a>
                            <div class="btn-booknow">
                                <a class="book-service" href="<?php echo($this->page_service_detail.'?service_id='.$service_start->id); ?>"><?php esc_attr_e('Book now', 'wpbookingpro') ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php foreach ($five_service_after as $service){?>
                    <div role="tabpanel" class="tab-pane " id="<?php esc_html_e($service->id);?>">
                        <div class="image">
                            <img src="<?php esc_html_e(Factory::getRootUrlPlugin())?>/<?php esc_html_e($service->image) ?>" alt="category-image" />
                        </div>
                        <div class="information">
                            <div class="name">
                                <h2><?php esc_html_e($service->name) ?></h2>
                            </div>
                            <div class="description">
                                <?php
                                $description=$service->description;
                                if(strlen($description)>110){?>
                                    <p title="<?php esc_html_e($description) ?>"><?php esc_html_e(substr($description,0,110)) ?><?php esc_attr_e('...', 'wpbookingpro') ?></p>
                                <?php } else { ?>
                                    <p><?php esc_html_e($description) ?></p>
                                <?php }
                                ?>
                            </div>
                            <div class="browse">
                                <a class="div-link" href="<?php echo($this->page_service_detail.'?service_id='.$service_start->id); ?>"><?php esc_attr_e('Link', 'wpbookingpro') ?></a>
                                <div class="btn-booknow">
                                    <a class="book-service" href="<?php echo($this->page_service_detail.'?service_id='.$service_start->id); ?>"><?php esc_attr_e('Book now', 'wpbookingpro') ?></a>
                                </div>
                            </div>
                        </div>

                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php
$doc= Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_servicebycategory/assets/less/block_servicebycategory.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block-servicebycategory-default','block_servicebycategory',array(),'frontend/blocks/block_servicebycategory/assets/js/block_servicebycategory.js');



