<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingProFrontend\app\Html\HtmlFrontend;
?>
    <div  class="block-searchmenu-default">
        <div class="row">
            <div class="col-md-12">
                <div class="block-search">
                    <ul class="nav nav-tabs tab-searchmenu">
                        <li class="active"><a data-toggle="tab" href="#training"><?php esc_attr_e('Training','wpbookingpro')?></a></li>
                        <li><a data-toggle="tab" href="#event"><?php esc_attr_e('Event','wpbookingpro')?></a></li>
                    </ul>
                    <div class="tab-content tab-searchmenu-content">
                        <div id="training" class="tab-pane fade in active">
                            <form action="<?php echo($page_list_service)  ?>" method="post">
                                <div class="wrapper-list-duration">
                                    <?php
                                    $field=$form_service->getField('duration');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                                <div class="wrapper-list-service">
                                    <?php
                                    $field=$form_service->getField('service_id');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                                <div class="wrapper-list-location">
                                    <?php
                                    $field=$form_service->getField('location_id');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                                <div class="wrapper-list-employee">
                                    <?php
                                    $field=$form_service->getField('employee_id');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                                <div class="button-search">
                                    <button class="btn btn-primary btn-search-training"><span><?php esc_attr_e('Search now','wpbookingpro')?></span></button>
                                </div>
                            </form>
                        </div>
                        <div id="event" class="tab-pane fade">
                            <form action="<?php echo Factory::getRootUrl() ?>wp-booking-pro?page=event-find_event_new" method="post">
                                <div class="wrapper-list-service">
                                    <?php
                                    $field=$form_service->getField('service_id');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                                <div class="wrapper-list-location">
                                    <?php
                                    $field=$form_service->getField('location_id');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                                <div class="wrapper-list-employee">
                                    <?php
                                    $field=$form_service->getField('employee_id');
                                    ?>
                                    <?php echo($field->input) ?>
                                </div>
                                <div class="button-search">
                                    <button class="btn btn-primary btn-search-event"><span><?php esc_attr_e('Search now','wpbookingpro')?></span></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
$doc= Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_searchmenu/assets/less/block_searchmenu.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block-searchmenu-default','block_searchmenu',array(),'frontend/blocks/block_searchmenu/assets/js/block_searchmenu.js');



