"use strict";
(function ($) {
    $.block_search_service = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('select[name="location"]').select2();
            $element.find('input[name="datetimes"]').daterangepicker({
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'DD/MM/YYYY'
                },
                maxYear: '+10',
                minDate: moment().format('DD/MM/YYYY')
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
            });
            $element.find('#slider-container-1').slider({
                range: true,
                min: 0,
                max: 1099,
                values: [0, 1099],
                create: function () {
                    $("#amount_1").val("$0 - $1099");
                },
                slide: function (event, ui) {
                    $("#amount_1").val("$" + ui.values[0] + " - $" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="price_search"]`).val(JSON.stringify(price_value));
                }
            });
            $element.find('#slider-container-2').slider({
                range: true,
                min: 0,
                max: 1099,
                values: [0, 1099],
                create: function () {
                    $("#amount_2").val("$0 - $1099");
                },
                slide: function (event, ui) {
                    $("#amount_2").val("$" + ui.values[0] + " - $" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="price_filter"]`).val(JSON.stringify(price_value));
                }
            });
            $element.find('.block-filter-price-more-option-2').slideUp();
            $element.find('.block-service-categories-2').slideUp();
            $element.find('.choose-employee_1').slideUp();
            $element.find('p.more-option').click(function (e) {
                let $block_more_option = $(this).closest('.block-more-option');
                $block_more_option.find('.block-filter-price-more-option-2').slideToggle();
                $block_more_option.find('.block-service-categories-2').slideToggle();
            });
            $element.find('.toggle-employee').click(function (e) {
                let $block_more_option = $(this).closest('.block-employee');
                $block_more_option.find('.choose-employee_1').slideToggle();
            })

        };
        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_search_service = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_search_service')) {
                let plugin = new $.block_search_service(this, options);
                $(this).data('block_search_service', plugin);
            }
        });
    }
    $('div.dropdown-menu').on('click', function(event){
        // The event won't be propagated up to the document NODE and
        // therefore delegated events won't be fired
        event.stopPropagation();
    });
})(jQuery);
