<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingProFrontend\app\Html\HtmlFrontend;
?>
    <div class="block-meetourcoachs-default">
        <h2>MEET OUR COACHS</h2>
        <div class="sp-slides">
            <div class="image-123">
                <div class="slider">
                    <?php foreach ($list_employee as $item) { ?>
                        <div class="wrapper-employee">
                            <div class="cover-image-service-trainer">
                                <div>
                                    <img src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($item->image) ?>" alt="service-trainer" />
                                </div>
                            </div>
                            <div class="tes-content">
                                <h3 class="name"><?php esc_html_e($item->full_name) ?></h3>
                                <p class="category"><?php echo(isset($item->category[0]->name)?$item->category[0]->name:'') ?></p>
                                <div class="content">
                                    <p>
                                        <?php esc_html_e($item->note_internal) ?>
                                    </p>
                                </div>
                                <div class="team-social">
                                    <a href="<?php esc_html_e($item->params->get('facebook')) ?>"><i
                                                class="icon-nb-phone-call"></i> </a>
                                    <a href="https://twitter.com"><i class="icon-nb-facebook"></i></a>
                                    <a href="<?php esc_html_e($item->params->get('googleplus')) ?>"><i
                                                class="icon-nb-instagram"></i> </a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
<?php
$doc= Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_meetourcoachs/assets/less/block_meetourcoachs.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block-meetourcoachs-default','block_meetourcoachs',array(),'frontend/blocks/block_meetourcoachs/assets/js/block_meetourcoachs.js');



