<?php
namespace WpBookingProBlock\block_meetourcoachs;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProFrontend\app\helpers\DestinationHelper;

class block_meetourcoachs_helper {
    public static function getListEmployee(){
        $db= FactoryAlias::getDBO();
        $query=$db->getQuery(true);
        $query->select('employee.*')
            ->from(UtilityAlias::getTableName('employee').' AS employee ')
            ->where('employee.published=1')
        ;
        $list=$db->setQuery($query)->loadObjectList();
        foreach ($list as &$item) {
            $item->full_name=$item->first_name. ' ' .$item->last_name;
            $register = new Registry();
            $register->loadString($item->params);
            $item->params = $register;
            $query->clear()
                ->select('service_employee.employee_id AS employee_id, service_employee.service_id AS service_id')
                ->from(UtilityAlias::getTableName('service_employee') . ' AS service_employee')
                ->leftJoin(UtilityAlias::getTableName('service') . ' AS service ON service.id=service_employee.service_id')
                ->leftJoin(UtilityAlias::getTableName('category') . ' AS category ON category.id=service.category_id')
                ->select('category.*')
                ->group('service_employee.employee_id')
                ->having('service_employee.employee_id=' . (int)$item->id);
            $item->category = $db->setQuery($query)->loadObjectList();
        }
        return $list;
    }




}