<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingProFrontend\app\Html\HtmlFrontend;
$page_service_detail = ConfigHelperAlias::get_page_service_detail();
$this->page_service_detail = get_page_link($page_service_detail);
?>
<div class="block-list-location">
    <div class="list-location slider">
        <?php foreach ($list as $item){ ?>
            <div class="each-location">
                <div class="image">
                    <img class="item-image" src="<?php esc_html_e(Factory::getRootUrlPlugin())?>/<?php esc_html_e($item->image) ?>" alt="" />
                </div>
                <div class="information">
                    <div class="number-service">
                        <?php
                            $number_service = count($item->list_service);
                        ?>
                        <span><?php esc_attr_e($number_service) ?></span>
                        <?php if($number_service>1){ ?>
                            <span><?php esc_attr_e('jobs', 'wpbookingpro') ?></span>
                        <?php } else{ ?>
                            <span><?php esc_attr_e('job', 'wpbookingpro') ?></span>
                        <?php } ?>

                    </div>
                    <div class="location-name-heart">
                        <span class="location-name"><?php esc_html_e($item->name) ?></span>
                        <i class="far fa-heart"></i>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
<?php
$doc= Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_location/assets/less/block_location.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block-list-location','block_location',array(),'frontend/blocks/block_location/assets/js/block_location.js');



