<?php
namespace WpBookingProBlock\block_listsixservice;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProFrontend\app\helpers\DestinationHelper;

class block_listsixservice_helper {
    public static function get_list_service_listsixservice(){
        $db= FactoryAlias::getDBO();
        $query=$db->getQuery(true);
        $query->select('service.*')
            ->from(UtilityAlias::getTableName('service').' AS service ')
            ->where('service.published=1 AND (service.featured=1 OR service.new=1 OR service.popular=1)')
            ->leftJoin(UtilityAlias::getTableName('category').' AS category ON category.id=service.category_id')
            ->select('category.name as category_name')
            ->leftJoin(UtilityAlias::getTableName('location').' AS location ON location.id=service.location_id')
            ->select('location.name as location_name')
        ;
        $list=$db->setQuery($query)->loadObjectList();
        foreach ($list as &$item){
            $query->clear()
                ->select('employee.*')
                ->from(UtilityAlias::getTableName('employee') . ' AS employee')
                ->leftJoin(UtilityAlias::getTableName('service_employee') . ' as service_employee ON service_employee.employee_id=employee.id')
                ->where('service_employee.service_id=' . (int)$item->id)
            ;
            $item->list_employee=$db->setQuery($query)->loadObjectList();
            $query->clear()
                ->select('review.*')
                ->from(UtilityAlias::getTableName('review') . ' AS review')
                ->where('review.service_id=' . (int)$item->id)
            ;
            $list_reviews = $db->setQuery($query)->loadObjectList();

            $query->clear()
                ->select('wishlist.user_id')
                ->from(UtilityAlias::getTableName('wishlist') . ' AS wishlist')
                ->where('wishlist.service_id=' . (int)$item->id)
            ;
            $item->user_wishlist=$db->setQuery($query)->loadColumn();

            foreach ($list_reviews as &$review){
                $review->rating_avg=($review->rating_ambience + $review->rating_cleanliness + $review->rating_staff + $review->rating_value)/4;
            }
            $item->list_reviews=$list_reviews;
        }
        return $list;
    }




}