<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingProFrontend\app\Html\HtmlFrontend;
$six_servcie=array_splice($list,0,6,false);
$page_service_detail = ConfigHelperAlias::get_page_service_detail();
$this->user=Factory::getUser();
$curent_user_id = $this->user->ID;
$this->page_service_detail = get_page_link($page_service_detail);
?>
    <div class="block-list-service-default">
        <div class="row">
            <div class="col-md-12">
                <div class="wrapper-slide-service-item">
                    <div class="row slider">
                        <?php foreach ($six_servcie as $item){ ?>
                            <div class="col-md-4 col-sm-6">
                                <div class="wrapper-service-item wishlist-item " data-service_id="<?php echo $item->id ?>" data-user_id="<?php echo  $this->user->id ?>">
                                    <div class="img-block">
                                        <img class="item-core-image" src="<?php esc_html_e(Factory::getRootUrlPlugin())?>/<?php esc_html_e($item->image) ?>" alt="item-core-image" />
                                        <div class="price">
                                            <p>$ <?php esc_html_e($item->price); ?></p>
                                        </div>
                                        <div class="rating">
                                            <ul class="list-rating-star ">
                                                <?php
                                                $number_review=count($item->list_reviews);
                                                $total_rating_avg = 0;
                                                foreach ($item->list_reviews as $list_review){
                                                    $total_rating_avg +=$list_review->rating_avg;
                                                }
                                                if($number_review>0){
                                                    $rating_avg_avg = $total_rating_avg / $number_review;
                                                } else{
                                                    $rating_avg_avg=0;
                                                }
                                                $list_star_sum = HtmlFrontend::get_rating_star($rating_avg_avg);
                                                ?>
                                                <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                                <?php }?>
                                                <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            </ul>
                                        </div>
                                        <div class="label">
                                            <?php if($item->featured==1){?>
                                                <p class="featured"><?php esc_attr_e('FEATURED', 'wpbookingpro') ?></p>
                                            <?php } else if ($item->featured==0 && $item->popular==1){?>
                                                <p class="popular"><?php esc_attr_e('POPULAR', 'wpbookingpro') ?></p>
                                            <?php } else if($item->featured==0 && $item->popular==0 & $item->new==1 ){?>
                                                <p class="new"><?php esc_attr_e('NEW', 'wpbookingpro') ?></p>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="wrapper-content">
                                        <h3 class="title-service"><?php esc_html_e($item->name); ?></h3>
                                        <div class="description"><?php esc_html_e($item->description); ?></div>
                                        <div class="location">
                                            <i class="icon-nb-pin"></i>
                                            <p><?php esc_html_e($item->location_name); ?></p>
                                        </div>
                                        <div class="buttons">
                                            <a href="<?php echo($this->page_service_detail.'?service_id='.$item->id); ?>" class="btn btn-primary btn-view-more"><?php esc_html_e('Book Now'); ?></a>
                                        </div>
                                    </div>
                                    <div class="category-name-heart">
                                        <p class="category-name"><?php esc_html_e($item->category_name); ?></p>
                                        <span class="heart <?php echo ((in_array($curent_user_id,$item->user_wishlist) )?' active ':'') ?>">
                                            <i class="icon-heart3"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
$doc= Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_listservice/assets/less/block_listservice.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block-list-service-default','block_listservice',array(),'frontend/blocks/block_listservice/assets/js/block_listservice.js');



