"use strict";
(function ($) {
    $.block_listservice = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.slider').slick({
                dots: true,
                infinite: true,
                slidesToShow: 3,
                slidesToScroll: 3,
                arrows: false,
                responsive: [
                    {
                        breakpoint: 992,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 575,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 375,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                ]
            });
        }
        $element.find('.heart').on('click', function () {
            $(this).toggleClass('active');
        });
        $element.find('.heart').on('click',function(e){
            let $service_item = $(this).closest('.wishlist-item');

            let service_id = $service_item.data('service_id');
            let user_id = $service_item.data('user_id');
            if(user_id==""){
                return;
            }
            let data = {
                task: "wishlist.change_wishlist",
                state: 1,
                service_id: service_id,
                user_id: user_id,
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {

                },
                error: function (xhr) {
                    
                },
                complete: function () {
                    
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        })
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_listservice = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_listservice')) {
                let plugin = new $.block_listservice(this, options);
                $(this).data('block_listservice', plugin);
            }
        });
    }
    $('div.dropdown-menu').on('click', function(event){
        // The event won't be propagated up to the document NODE and
        // therefore delegated events won't be fired
        event.stopPropagation();
    });
})(jQuery);
