<?php
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

$doc= FactoryAlias::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-services.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
WpBookingProHtmlFrontend::load_jquery_library('datatables');
WpBookingProHtmlFrontend::load_jquery_library('moment');
WpBookingProHtmlFrontend::load_jquery_library('daterangepicker');
WpBookingProHtmlFrontend::load_jquery_library('awesome');
WpBookingProHtmlFrontend::load_jquery_library('ui');
WpBookingProHtmlFrontend::load_jquery_library('icheck');
WpBookingProHtmlFrontend::load_jquery_library('twbs_pagination');
WpBookingProHtmlFrontend::load_jquery_library('select2');
WpBookingProHtmlFrontend::load_jquery_library('loading_js');
WpBookingProHtmlFrontend::load_jquery_library('confirm');
$page_service_detail = ConfigHelperAlias::get_page_service_detail();
if ($page_service_detail) {
    $this->page_service_detail = get_page_link($page_service_detail);
} else {
    $this->page_service_detail = "";
}
$number_service = $this->totalRecord;
$page_list_service = ConfigHelperAlias::get_page_list_service();
if ($page_list_service) {
    $page_list_service = get_page_link($page_list_service);
} else {
    $page_list_service = "";
}

$input = FactoryAlias::getInput();
$this->location_id = $input->getInt('location_id', 0);
$this->employee_id = $input->getInt('employee_id', 0);
$this->category_id = $input->getInt('category_id', 0);
$this->service_id = $input->getInt('service_id', 0);
$this->keyword = $input->getString('keyword', "");
$start = $input->getInt('start', 0);
$limit = $input->getInt('limit', 6);
$sort = $input->getString('sort', 'a.ordering');
$direction = $input->getString('direction', '');
$list_service_id = [];

if (array_key_exists('service_id', (array)$input->getData())) {
    $list_service_id = (array)$input->getData()['service_id'];
}
$list_category_id = [];
if (array_key_exists('category_id', (array)$input->getData())) {
    $list_category_id = (array)$input->getData()['category_id'];
}
$this->total_rating_avg = $input->getInt('total_rating_avg', 0);
?>
    <div class="view-list-services">
        <form action="<?php echo($page_list_service) ?>" method="post" class="form-search-service">
            <div class="row">
                <div class="col-md-3">
                    <div class="wrapper-search-service">
                        <div class="find_your_services">
                            <h4><?php esc_attr_e('Find Your services', 'wpbookingpro') ?></h4>
                            <div class="search">
                                <i class="icon-nb-search icon-keyword-search"></i>
                                <input type="text" value="<?php echo $this->keyword ?>" class="search form-control"
                                       name="keyword"
                                       placeholder="<?php esc_attr_e('What are you looking for', 'wpbookingpro') ?>"/>
                            </div>
                            <div class="list-employee">
                                <select name="employee_id" class="list-employee">
                                    <option value=""><?php esc_attr_e('Choose Your Expert', 'wpbookingpro') ?></option>
                                    <?php foreach ($this->list_employees as $employee) { ?>
                                        <option <?php echo ($this->employee_id == $employee->id) ? 'selected' : '' ?>
                                                value="<?php esc_html_e($employee->id); ?>"><?php esc_html_e($employee->full_name); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="list-location">
                                <select name="location_id" class="list-location">
                                    <option value=""><?php esc_attr_e('Select Address', 'wpbookingpro') ?></option>
                                    <?php foreach ($this->list_locations as $location) { ?>
                                        <option <?php echo ($this->location_id == $location->id) ? 'selected' : '' ?>
                                                value="<?php esc_html_e($location->id); ?>"><?php esc_html_e($location->address); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="list-category">
                            <h4><?php esc_attr_e('Filter By category', 'wpbookingpro') ?></h4>
                            <ul class="ul-list-category">
                                <?php foreach ($this->list_categories as $category) { ?>
                                    <li>
                                        <div class="block-label">
                                            <label class="label-category">
                                                <?php if (count((array)$list_category_id)) { ?>
                                                    <input <?php echo(in_array($category->id, $list_category_id) ? 'checked' : '') ?>
                                                            type="checkbox" class="check-box-category"
                                                            name="category_id[]" value="<?php echo($category->id); ?>"/>
                                                    <span><?php echo($category->name); ?></span>
                                                <?php } else { ?>
                                                    <input type="checkbox" class="check-box-category"
                                                           name="category_id[]" value="<?php echo($category->id); ?>"/>
                                                    <span><?php echo($category->name); ?></span>
                                                <?php } ?>
                                                (<span><?php esc_html_e(count((array)$category->list_service)); ?></span>)
                                            </label>
                                            <i class="icon-nb-down-arrow"></i>
                                        </div>
                                        <ul class="ul-list-service">
                                            <?php foreach ($category->list_service as $service) { ?>
                                                <?php if (count((array)$list_service_id)) { ?>
                                                    <li>
                                                        <label><input <?php echo(in_array($service->id, $list_service_id) ? 'checked' : '') ?>
                                                                    type="checkbox" name="service_id[]"
                                                                    value="<?php echo($service->id); ?>"/>
                                                            <span><?php echo($service->name); ?></span></label></li>
                                                <?php } else { ?>
                                                    <li><label><input type="checkbox" name="service_id[]"
                                                                      value="<?php echo($service->id); ?>"/>
                                                            <span><?php echo($service->name); ?></span></label></li>
                                                <?php } ?>
                                            <?php } ?>
                                        </ul>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                        <div class="list-rating">
                            <h4><?php esc_attr_e('Filter By Rating', 'wpbookingpro') ?></h4>
                            <ul class="ul-list-rating">
                                <?php for ($i = 0; $i < 5; $i++) { ?>
                                    <li>
                                        <div class="block-label">
                                            <label class="label-rating">
                                                <input <?php echo($this->total_rating_avg == (5 - $i) ? ' checked ' : "unchecked") ?>
                                                        type="radio" class="check-box-rating" name="total_rating_avg"
                                                        value="<?php echo(5 - $i) ?>"/>
                                                <span>
                                                <ul class="list-rating-star ">
                                                    <?php for ($j = 0; $j < 5 - $i; $j++) { ?>
                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                    <?php } ?>
                                                    <?php for ($k = 0; $k < $i; $k++) { ?>
                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                    <?php } ?>
                                                </ul>
                                            </span>
                                            </label>
                                        </div>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                        <button type="submit"
                                class="btn btn-primary button-filter"><?php esc_attr_e('Search', 'wpbookingpro'); ?></button>
                    </div>
                </div>
                <div class="col-md-9">
                    <?php if ($number_service > 0) { ?>
                        <div class="wrapper-block-result">
                            <div class="block-top-result">
                                <div class="result-title">
                                    <h3><?php echo($number_service) ?><?php esc_attr_e('services found', 'wpbookingpro'); ?></h3>
                                </div>
                                <div class="block-sorting-display">
                                    <div class="block-display-button">
                                        <ul class="nav nav-tabs">
                                            <li class="active"><a data-toggle="tab" href="#grid-display"><i
                                                            class="fas fa-th"></i></a></li>
                                            <li><a data-toggle="tab" href="#list-display"><i
                                                            class="fas fa-list"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="sort-by-price">
                                    <div class="dropdown">
                                        <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:;">
                                            <p class="sort-by <?php echo $direction==""?>"><?php esc_attr_e('Sort By', 'wpbookingpro') ?></p>
                                            <span>
                                                <i class="fas fa-sort-down"></i>
                                            </span>
                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            <ul class="sort-display">
                                                <li class="<?php echo $sort == "price ASC" ? ' active ' : '' ?>">
                                                    <a class="lowest-price" data-sort="a.price" data-direction="ASC" href="javascript:void()">
                                                        <?php esc_attr_e('Lowest Price', 'wpbookingpro') ?>
                                                    </a>
                                                </li>
                                                <li class="<?php echo $sort == "price DESC" ? ' active ' : '' ?>">
                                                    <a class="highest-price" data-sort="a.price" data-direction="DESC" href="javascript:void()">
                                                        <?php esc_attr_e('Highest Price', 'wpbookingpro') ?>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-content wrapper-result-body">
                                <div id="grid-display" class="tab-pane fade in active">
                                    <div class="row">
                                        <?php foreach ($this->list as $service) { ?>
                                            <?php
                                            $this->service = $service;
                                            ?>
                                            <div class="col-sm-6 col-md-4"><?php $this->loadTemplate('list_item') ?></div>
                                        <?php } ?>
                                    </div>
                                </div>
                                <div id="list-display" class="tab-pane fade">
                                    <?php foreach ($this->list as $service) { ?>
                                        <?php
                                        $this->service = $service;
                                        ?>
                                        <?php $this->loadTemplate('list_row_item') ?>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    <?php } else { ?>
                        <div class="wrapper-block-result">
                            <div class="block-top-result">
                                <div class="result-title">
                                    <h3><?php echo($number_service) ?><?php esc_attr_e('Could not find any services', 'wpbookingpro'); ?></h3>
                                </div>
                                <div class="block-sorting-display">
                                    <div class="block-display-button">
                                        <ul class="nav nav-tabs">
                                            <li class="active"><a data-toggle="tab" href="#grid-display"><i
                                                            class="fas fa-th"></i></a></li>
                                            <li><a data-toggle="tab" href="#list-display"><i
                                                            class="fas fa-list"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="sort-by-price">
                                    <div class="dropdown">
                                        <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:;">
                                            <p class="sort-by <?php echo $direction==""?>"><?php esc_attr_e('Sort By', 'wpbookingpro') ?></p>
                                            <span>
                                                <i class="fas fa-sort-down"></i>
                                            </span>
                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            <ul class="sort-display">
                                                <li class="<?php echo $sort == "price ASC" ? ' active ' : '' ?>">
                                                    <a class="lowest-price" data-sort="a.price" data-direction="ASC" href="javascript:void()">
                                                        <?php esc_attr_e('Lowest Price', 'wpbookingpro') ?>
                                                    </a>
                                                </li>
                                                <li class="<?php echo $sort == "price DESC" ? ' active ' : '' ?>">
                                                    <a class="highest-price" data-sort="a.price" data-direction="DESC" href="javascript:void()">
                                                        <?php esc_attr_e('Highest Price', 'wpbookingpro') ?>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="tab-content wrapper-result-body">
                                <div id="grid-display" class="tab-pane fade in active">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="alert-block">
                                                <span><?php esc_attr_e('Could not find any services', 'wpbookingpro') ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="list-display" class="tab-pane fade">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="alert-block">
                                                <span><?php esc_attr_e('Could not find any services', 'wpbookingpro') ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <div id="pagination-services"></div>
                </div>
            </div>
            <input type="hidden" name="start" value="<?php echo $start ?>">
            <input type="hidden" name="sort" value="<?php echo $sort ?>">
            <input type="hidden" name="direction" value="<?php echo $direction ?>">
        </form>
    </div>
<?php
$input = FactoryAlias::getInput();
$doc->addScriptApplySelector('.view-list-services', 'view_list_services', array(
    'data_input' => $input->getData(),
    'total_record' => $this->totalRecord,
    "limit" => $limit,
    "start" => $start,
    "page_list_service"=>$page_list_service
), "frontend/app/assets/js/view_list_services.js");
?>