<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingProFrontend\app\Html\HtmlFrontend;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-services.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
WpBookingProHtmlFrontend::load_jquery_library('datatables');
WpBookingProHtmlFrontend::load_jquery_library('moment');
WpBookingProHtmlFrontend::load_jquery_library('daterangepicker');
WpBookingProHtmlFrontend::load_jquery_library('fontawesome');
WpBookingProHtmlFrontend::load_jquery_library('ui');
WpBookingProHtmlFrontend::load_jquery_library('icheck');
WpBookingProHtmlFrontend::load_jquery_library('select2');
WpBookingProHtmlFrontend::load_jquery_library('loading_js');
WpBookingProHtmlFrontend::load_jquery_library('confirm');
WpBookingProHtmlFrontend::load_jquery_library('store_locator_js');
WpBookingProHtmlFrontend::load_jquery_library('twbs_pagination');
$page_service_detail = ConfigHelperAlias::get_page_service_detail();
if ($page_service_detail) {
    $this->page_service_detail = get_page_link($page_service_detail);
} else {
    $this->page_service_detail = "";
}
$number_service = count($this->list);
$page_list_service = ConfigHelperAlias::get_page_list_service();
if ($page_list_service) {
    $page_list_service = get_page_link($page_list_service);
} else {
    $page_list_service = "";
}

$input = FactoryAlias::getInput();
$location_id = $input->getInt('location', 0);
$near_me = $input->getInt('near_me', 0);
$sort = $input->getString('sort', 'a.ordering');
$direction = $input->getString('direction', '');
$rating = $input->getString('rating','');

$one_star = array();
$two_star = array();
$three_star = array();
$four_star = array();
$five_star = array();
foreach ($this->list as $service_item) {
    if(isset($service_item->rating_avg)) {
        if($service_item->rating_avg >= 0 && $service_item->rating_avg <= 1) {
            array_push($one_star, $service_item);
        } elseif($service_item->rating_avg > 1 && $service_item->rating_avg <= 2) {
            array_push($two_star, $service_item);
        } elseif($service_item->rating_avg > 2 && $service_item->rating_avg <= 3) {
            array_push($three_star, $service_item);
        } elseif($service_item->rating_avg > 3 && $service_item->rating_avg <= 4) {
            array_push($four_star, $service_item);
        } elseif($service_item->rating_avg > 4 && $service_item->rating_avg <= 5) {
            array_push($five_star, $service_item);
        }
    }
}

?>

    <div class="view-list-servicelocator">
        <form action="" method="post" name="filter-form" id="bh-sl-user-location" class="form-search-service">
            <div class="row">
                <div class="col-md-12">
                    <div class="wrapper-search-service bh-sl-filters-container">
                        <div class="find_your_services">
                            <h4><?php esc_attr_e('Find Your services', 'wpbookingpro') ?></h4>
                            <div class="search">
                                <i class="icon-nb-search icon-keyword-search"></i>
                                <input type="text" value="" id="bh-sl-search" class="search form-control" name="keyword"
                                       placeholder="<?php esc_attr_e('What are you looking for', 'wpbookingpro') ?>"/>
                            </div>
                            <div class="block-location-near-me">
                                <label class="label-near-me">
                                    <input type="checkbox" class="input-near-me" name="near_me" value="1" />
                                    <?php esc_html_e('Near you','wpbookingpro');?>
                                </label>
                                <input type="hidden" name="latitude">
                                <input type="hidden" name="longitude">
                            </div>
                            <div class="list-employee bh-sl-filters">
                                <select name="employee" class="list-employee">
                                    <option value=""><?php esc_attr_e('Choose Your Expert', 'wpbookingpro') ?></option>
                                    <?php foreach ($this->list_employees as $employee) { ?>
                                        <option
                                            value="<?php esc_html_e($employee->id); ?>"><?php esc_html_e($employee->full_name); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="list-location bh-sl-filters">
                                <select name="location_id" class="list-location">
                                    <option value=""><?php esc_attr_e('Select Address', 'wpbookingpro') ?></option>
                                    <?php foreach ($this->list_locations as $location) { ?>
                                        <option
                                            value="<?php esc_html_e($location->id); ?>"><?php esc_html_e($location->address); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="content-left srat-ratings">
                            <h4 class="title-left"><?php esc_html_e('Star Ratings', 'wpbookinghotel');?></h4>
                            <div class="block-filter-star">
                                <div class="item-star-filter">
                                    <input type="checkbox" name="rating[]" id="five-star" value="[4,5]" <?php echo ($rating!='' && is_array($rating) && in_array('[4,5]',$rating)?'checked':'');?>>
                                    <label for="five-star">
                                        <ul class="list-rating-star">
                                            <?php for($i = 1; $i <= 5; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                        <span class="number-hotel">
                                                    <?php echo (esc_html(count($five_star)));?>
                                                </span>
                                    </label>
                                </div>
                                <div class="item-star-filter">
                                    <input type="checkbox" name="rating[]" id="four-star" value="[3,4]" <?php echo ($rating!='' && is_array($rating) && in_array('[3,4]',$rating)?'checked':'');?>>
                                    <label for="four-star">
                                        <ul class="list-rating-star">
                                            <?php for($i = 1; $i <= 4; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        </ul>
                                        <span class="number-hotel">
                                                    <?php echo (esc_html(count($four_star)));?>
                                                </span>
                                    </label>
                                </div>
                                <div class="item-star-filter">
                                    <input type="checkbox" name="rating[]" id="three-star" value="[2,3]" <?php echo ($rating!='' && is_array($rating) && in_array('[2,3]',$rating)?'checked':'');?>>
                                    <label for="three-star">
                                        <ul class="list-rating-star">
                                            <?php for($i = 1; $i <= 3; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for($i = 1; $i <= 2; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                        <span class="number-hotel">
                                                    <?php echo (esc_html(count($three_star)));?>
                                                </span>
                                    </label>
                                </div>
                                <div class="item-star-filter">
                                    <input type="checkbox" name="rating[]" id="two-star" value="[1,2]" <?php echo ($rating!='' && is_array($rating) && in_array('[1,2]',$rating)?'checked':'');?>>
                                    <label for="two-star">
                                        <ul class="list-rating-star">
                                            <?php for($i = 1; $i <= 2; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for($i = 1; $i <= 3; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                        <span class="number-hotel">
                                                    <?php echo (esc_html(count($two_star)));?>
                                                </span>
                                    </label>
                                </div>
                                <div class="item-star-filter">
                                    <input type="checkbox" name="rating[]" id="one-star" value="[0,1]" <?php echo ($rating!='' && is_array($rating) && in_array('[0,1]',$rating)?'checked':'');?>>
                                    <label for="one-star">
                                        <ul class="list-rating-star">
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php for($i = 1; $i <= 4; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        </ul>
                                        <span class="number-hotel">
                                                    <?php echo (esc_html(count($one_star)));?>
                                                </span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="wrapper-price-rating">
                            <div class="block-filter-price block-filter-price-more-option">
                                <h4><?php esc_attr_e('Filter price','wpbookingpro');?></h4>
                                <input type="text" id="amount_1" readonly/>
                                <div id="slider-container-1"></div>
                                <input type="hidden" name="price_search">
                            </div>
                            <div class="list-category">
                                <h4><?php esc_attr_e('Filter By category', 'wpbookingpro') ?></h4>
                                <ul class="ul-list-category bh-sl-filters">
                                    <?php foreach ($this->list_categories as $category) { ?>
                                        <li>
                                            <div class="block-label">
                                                <label class="label-category">
                                                    <input type="checkbox" class="check-box-category"
                                                           name="category[]" value="<?php echo($category->id); ?>"/>
                                                    <span><?php echo($category->name); ?></span>
                                                    (<span><?php esc_html_e(count((array)$category->list_service)); ?></span>)
                                                </label>
                                            </div>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="bh-sl-container">
                        <div id="bh-sl-map-container" class="bh-sl-map-container">
                            <div class="wrapper-content-left">
                                <div class="block-top-result bh-sl-filters-container">
                                    <div class="result-title">
                                        <h3><span class="number-service"><?php echo($number_service) ?></span><?php esc_attr_e('services found', 'wpbookingpro'); ?></h3>
                                    </div>
                                    <div class="block-sorting-display">
                                        <div class="block-display-button">
                                            <div class="nav nav-tabs">
                                                <div class="active"><a data-toggle="tab" href="#grid-display"><i
                                                                class="fas fa-th"></i></a></div>
                                                <div><a data-toggle="tab" href="#list-display"><i
                                                                class="fas fa-list"></i></a></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="sort-by-price">
                                        <div class="dropdown">
                                            <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:void(0)">
                                                <span class="select-by-default"><?php esc_attr_e('Sort by', 'wpbookingpro') ?></span>
                                                <i class="fas fa-chevron-down"></i>
                                            </a>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <ul class="sort-display bh-sl-filters">
                                                    <li class="<?php echo ($sort=="a.price" && $direction=="ASC"?' active ':'') ?>">
                                                        <a class="lowest-price select-sort-item <?php echo ($sort=="a.price" && $direction=="ASC"?' active ':'') ?>" data-key_sort="a.price" data-direction="ASC" href="javascript:void(0)">
                                                            <?php esc_attr_e('Lowest price', 'wpbookingpro') ?>
                                                        </a>
                                                    </li>
                                                    <li class="<?php echo ($sort=="a.price" && $direction=="DESC"?' active ':'') ?>">
                                                        <a class="highest-price select-sort-item <?php echo ($sort=="a.price" && $direction=="DESC"?' active ':'') ?>" data-key_sort="a.price" data-direction="DESC"   href="javascript:void(0)">
                                                            <?php esc_attr_e('Highest price', 'wpbookingpro') ?>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-content wrapper-result-body">
                                    <div id="grid-display" class="tab-pane fade in active">
                                        <div class="bh-sl-loc-grid">
                                            <div class="grid row">
                                            </div>
                                        </div>
                                    </div>
                                    <div id="list-display" class="tab-pane fade">
                                        <div class="bh-sl-loc-list">
                                            <div class="list">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="bh-sl-map" class="bh-sl-map"></div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="bh-sl-pagination-container">
                        <ol class="bh-sl-pagination">

                        </ol>
                    </div>
                </div>
            </div>
            <input type="hidden" name="sort" value="<?php echo (esc_attr($sort)) ?>">
            <input type="hidden" name="direction" value="<?php echo (esc_attr($direction)) ?>">
            <input type="hidden" name="link_service_detail" value="<?php echo (esc_attr($this->page_service_detail)) ?>">
        </form>
    </div>
<?php
$input = FactoryAlias::getInput();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-servicelocator.less');
$doc->addScriptApplySelector('.view-list-servicelocator', 'view_list_servicelocator', array(
    'data_input' => $input->getData(),
    'list_service'=>$this->list,

), "frontend/app/assets/js/view_list_servicelocator.js");
?>