<?php

use WpBookingPro\Factory;
use WpBookingProFrontend\app\Html\HtmlFrontend;
\WpBookingPro\Html\WpBookingProHtmlFrontend::load_jquery_library('awesome');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view_payment_paynow.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$item = $this->order->list_rate;
$total = 0;
?>
    <div class="view-payment-paynow">
        <div class="view-list-paynow">
            <?php if(!empty((array)($this->order->list_rate))) {?>
                <?php foreach ($this->order->list_rate as $item) { ?>
                    <?php
                    $this->item = $item;
                    $total += $item->total;
                    ?>
                    <?php $this->loadTemplate('list_item') ?>
                <?php } ?>
            <?php }?>
            <div class="row">
                <div class="col-md-4"></div>
                <div class="col-sm-6 col-md-4"></div>
                <div class="col-sm-6 col-md-4">
                    <div class="cart-totals" >
                        <div class="detail-cart">
                            <?php if(!empty((array)($this->order->list_rate))) { ?>
                                <h3><?php esc_attr_e('Payment totals','wpbookingpro')?></h3>
                                <div class="block-payment-total">
                                    <span ><?php esc_attr_e('Payment subtotal','wpbookingpro')?></span>
                                    <span class="subtotal_price"><?php echo(HtmlFrontend::render_price($total)); ?></span>

                                </div>
                                <div class="block-shipping">
                                    <span><?php esc_attr_e('Shipping','wpbookingpro')?></span>
                                    <span class="shipping-price">0</span>
                                </div>
                                <div class="order_total_price">
                                    <span><?php esc_attr_e('Order total','wpbookingpro')?></span>
                                    <span class="total-price"><?php echo(HtmlFrontend::render_price($total)); ?></span>
                                </div>
                            <?php } else {?>
                                <h3><?php esc_attr_e('Payment totals','wpbookingpro')?></h3>
                                <div class="block-payment-total">
                                    <span ><?php esc_attr_e('Payment subtotal','wpbookingpro')?></span>
                                    <span class="subtotal_price"><?php echo(HtmlFrontend::render_price($this->order_package->total)); ?></span>

                                </div>
                                <div class="block-shipping">
                                    <span><?php esc_attr_e('Shipping','wpbookingpro')?></span>
                                    <span class="shipping-price">0</span>
                                </div>
                                <div class="order_total_price">
                                    <span><?php esc_attr_e('Order total','wpbookingpro')?></span>
                                    <span class="total-price"><?php echo(HtmlFrontend::render_price($this->order_package->total)); ?></span>
                                </div>
                            <?php }?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4"></div>
                <div class="col-md-4"></div>
                <div class="col-md-4">
                    <div class="checkout-cart">
                        <?php if(!empty((array)($this->order->list_rate))) {?>
                            <?php echo($this->paymentPlugin->onAfterOrderConfirm($this->order)) ?>
                        <?php }?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-payment-paynow','view_payment_paynow',array(
    "list_rate"=>  $this->order->list_rate
),'frontend/app/assets/js/view_payment_paynow.js');
